/**
 * @file IDeviceIdServiceRecordAlpsEvolutionExt.h
 *
 * @par SW-Component
 * State machine for device id service record
 *
 * @brief Interface definition for Alps Evolution Genivi device id service record state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the Alps Evolution Genivi interface for device id service record state machine.
 */

#ifndef _I_DEVICE_ID_SERVICE_RECORD_ALPS_EVOLUTION_EXT_H_
#define _I_DEVICE_ID_SERVICE_RECORD_ALPS_EVOLUTION_EXT_H_

#include "EvolutionGeniviStackTypes.h"

namespace btstackif {

// class forward declarations
class IDeviceIdServiceRecordRequest;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

namespace genivi {
namespace alpsevolutionext {

/**
 * Interface definition.
 */
class IDeviceIdServiceRecordAlpsEvolutionExt
{
public:
   /**
    * Destructor.
    */
   virtual ~IDeviceIdServiceRecordAlpsEvolutionExt() {}

   /**
    * Get request interface.
    *
    * @return = request interface
    */
   virtual IDeviceIdServiceRecordRequest* getRequestIf(void) = 0;

   /**
    * Handle set device id record result.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] errorCode: error code (result)
    */
   virtual void handleDidSetReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode) = 0;

   /**
    * Handle set device id record confirmation.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] status: status
    */
   virtual void handleDidSetCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSStatusCode status) = 0;
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_I_DEVICE_ID_SERVICE_RECORD_ALPS_EVOLUTION_EXT_H_
