/**
 * @file DeviceIdServiceRecordAlpsEvolutionExt.h
 *
 * @par SW-Component
 * State machine for device id service record
 *
 * @brief Implementation of Alps Evolution Genivi device id service record state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Alps Evolution Genivi device id service record state machine.
 */

#ifndef _DEVICE_ID_SERVICE_RECORD_ALPS_EVOLUTION_EXT_H_
#define _DEVICE_ID_SERVICE_RECORD_ALPS_EVOLUTION_EXT_H_

#include "IDeviceIdServiceRecordRequest.h"
#include "IDeviceIdServiceRecordAlpsEvolutionExt.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {
namespace alpsevolutionext {

/**
 * Device id service record class.
 */
class DeviceIdServiceRecordAlpsEvolutionExt : public IDeviceIdServiceRecordRequest, public IDeviceIdServiceRecordAlpsEvolutionExt
{
public:
   /**
    * Default constructor.
    */
   DeviceIdServiceRecordAlpsEvolutionExt();

   /**
    * Destructor.
    */
   virtual ~DeviceIdServiceRecordAlpsEvolutionExt();

   virtual void reset(void);

   virtual void setCallback(IN IDeviceIdServiceRecordCallback* callback);

   virtual void setDeviceIdServiceRecord(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSDeviceIdServiceRecord& serviceRecord);

   virtual IDeviceIdServiceRecordRequest* getRequestIf(void);

   virtual void handleDidSetReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode);

   virtual void handleDidSetCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSStatusCode status);

private:
   IDeviceIdServiceRecordCallback* _callback; /**< callback interface */
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_DEVICE_ID_SERVICE_RECORD_ALPS_EVOLUTION_EXT_H_
