/**
 * @file BluetoothLowEnergyAlpsEvolutionExt.h
 *
 * @par SW-Component
 * State machine for Bluetooth Low Energy
 *
 * @brief Implementation of Alps Evolution Genivi Bluetooth Low Energy state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Alps Evolution Genivi Bluetooth Low Energy state machine.
 */

#ifndef _BLUETOOTH_LOW_ENERGY_ALPS_EVOLUTION_EXT_H_
#define _BLUETOOTH_LOW_ENERGY_ALPS_EVOLUTION_EXT_H_

#include "IBluetoothLowEnergyAlpsEvolutionExt.h"
#include "DbusServiceAvailability.h"

namespace btstackif {
namespace genivi {
namespace alpsevolutionext {

/**
 * Bluetooth Low Energy class.
 */
class BluetoothLowEnergyAlpsEvolutionExt : public IBluetoothLowEnergyAlpsEvolutionExt
{
public:
   /**
    * Default constructor.
    */
   BluetoothLowEnergyAlpsEvolutionExt();

   /**
    * Destructor.
    */
   virtual ~BluetoothLowEnergyAlpsEvolutionExt();

   virtual void setControlIf(IN IBasicControl* control);

   virtual void setTimerPoolIf(IN ITimerPool* timerPool);

   virtual void enable(IN const bool enable);

   virtual bool getEnabled(void) const;

   virtual void setStackConfiguration(OUT ::std::vector< BTSDbusInterfaceItem >& dbusInterfaces, IN const BTSLocalStackConfiguration& configuration, IN const BTSUserMode userMode, IN const BTSInterfaceType interface);

   virtual bool handleIpc2BtsServiceAvailabilityConnection(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_ServiceAvailabilityConnection* message);
   virtual bool handleIpc2BtsGetAllPropertiesConnection(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_GetAllPropertiesConnection* message);
   virtual bool handleIpc2BtsCreateLeDeviceResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_CreateLeDeviceResult* message);
   virtual bool handleIpc2BtsRemoveLeDeviceResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_RemoveLeDeviceResult* message);
   virtual bool handleIpc2BtsLeAdapterInitialization(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterInitialization* message);
   virtual bool handleIpc2BtsLeDeviceCreated(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceCreated* message);
   virtual bool handleIpc2BtsLeDeviceRemoved(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceRemoved* message);
   virtual bool handleIpc2BtsLeAdapterAddressTypeUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAddressTypeUpdate* message);
   virtual bool handleIpc2BtsLeAdapterAddressUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAddressUpdate* message);
   virtual bool handleIpc2BtsLeAdapterAliasUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAliasUpdate* message);
   virtual bool handleIpc2BtsLeAdapterAdvertisingTimeoutUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate* message);
   virtual bool handleIpc2BtsLeAdapterDiscoverableModeUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterDiscoverableModeUpdate* message);
   virtual bool handleIpc2BtsLeAdapterAdvertisingDataUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAdvertisingDataUpdate* message);
   virtual bool handleIpc2BtsLeAdapterAdvertiseEnableUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAdvertiseEnableUpdate* message);
   virtual bool handleIpc2BtsAddLeDeviceObjectPathMapping(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_AddLeDeviceObjectPathMapping* message);
   virtual bool handleIpc2BtsDelLeDeviceObjectPathMapping(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_DelLeDeviceObjectPathMapping* message);
   virtual bool handleIpc2BtsLeDeviceDisconnectResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceDisconnectResult* message);
   virtual bool handleIpc2BtsLeDisconnectionComp(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDisconnectionComp* message);
   virtual bool handleIpc2BtsLeDeviceAddressTypeUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceAddressTypeUpdate* message);
   virtual bool handleIpc2BtsLeDeviceAddressUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceAddressUpdate* message);
   virtual bool handleIpc2BtsLeDeviceConnectedUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceConnectedUpdate* message);
   virtual bool handleIpc2BtsSendSeamlessPairingErrorCodeResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SendSeamlessPairingErrorCodeResult* message);
   virtual bool handleIpc2BtsSeamlessPairingAllowAccessResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SeamlessPairingAllowAccessResult* message);
   virtual bool handleIpc2BtsSeamlessPairingErrorCodeReceived(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SeamlessPairingErrorCodeReceived* message);
   virtual bool handleIpc2BtsSeamlessPairingAccessRequest(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SeamlessPairingAccessRequest* message);
   virtual bool handleIpc2BtsSeamlessPairingPairingDataUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SeamlessPairingPairingDataUpdate* message);

private:
   IBasicControl* _controlIf; /**< basic control interface */
   ITimerPool* _timerPoolIf; /**< timer pool interface */
   bool _enabled; /**< enabled flag */

   // group service
   DbusServiceGroupStatus _serviceGroupBLEGeneral; /**< grouped service status */
   // general services
   DbusServiceStatus _serviceStatusBLEObjectManagerSystem; /**< service status for object manager */
   DbusServiceStatus _serviceStatusBLEPropertiesGetAll; /**< service status for properties get all */
   DbusServiceStatus _serviceStatusBLEGenInitialization; /**< service status for initialization (GENIVI part) */
   DbusServiceStatus _serviceStatusBLEHliInitialization; /**< service status for initialization (HLI part) */
   // specific services
   DbusServiceStatus _serviceStatusBLEAdapter; /**< service status for BLE adapter */
   DbusServiceStatus _serviceStatusBLEDevice; /**< service status for BLE device */
   DbusServiceStatus _serviceStatusBLESeamlessPairing; /**< service status for BLE seamless pairing */
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_BLUETOOTH_LOW_ENERGY_ALPS_EVOLUTION_EXT_H_
