/**
 * @file BasicConfigurationAlpsEvolutionExt.h
 *
 * @par SW-Component
 * State machine for basic configuration
 *
 * @brief Implementation of Alps Evolution Genivi basic configuration state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Alps Evolution Genivi basic configuration state machine.
 */

#ifndef _BASIC_CONFIGURATION_ALPS_EVOLUTION_EXT_H_
#define _BASIC_CONFIGURATION_ALPS_EVOLUTION_EXT_H_

#include "IBasicConfigurationRequest.h"
#include "IBasicConfigurationAlpsEvolutionExt.h"

namespace btstackif {

// class forward declarations
class Ipc2Bts_BaseMessage;

namespace genivi {
namespace alpsevolutionext {

/**
 * Alps Evolution Genivi basic configuration class.
 */
class BasicConfigurationAlpsEvolutionExt : public IBasicConfigurationRequest, public IBasicConfigurationAlpsEvolutionExt
{
public:
   /**
    * Default constructor.
    */
   BasicConfigurationAlpsEvolutionExt();

   /**
    * Destructor.
    */
   virtual ~BasicConfigurationAlpsEvolutionExt();

   virtual void reset(void);

   virtual void setCallback(IN IBasicConfigurationCallback* callback);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void getConfigurationParameter(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter);

   virtual void setConfigurationParameter(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data);

   virtual void setConfigurationParameter(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const ::std::string& data);

   virtual void sendVirtualConfigurationParameterUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data, IN const BTSIpcCommonErrorCode errorCode);

   virtual void sendVirtualConfigurationParameterUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSConfigurationParameter configurationParameter, IN const ::std::string& data, IN const BTSIpcCommonErrorCode errorCode);

   virtual IBasicConfigurationRequest* getRequestIf(void);

   virtual void handleSetConfigurationReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId);

   virtual void handleSetConfigurationCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSStatusCode status, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId);

   virtual void handleReadConfigurationReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId);

   virtual void handleReadConfigurationCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSStatusCode status, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId, IN const BTSEvoConfigDataStream& data);

private:
   IBasicConfigurationCallback* _callback; /**< callback interface */
   IBasicControl* _controlIf; /**< basic control interface */
   ::std::map< BTSConfigurationParameter, uint64_t > _requestedData; /**< map containing requested configuration data */

   BTSEvoConfigIdEnum convert2EvolutionId(IN const BTSConfigurationParameter configurationParameter) const;

   BTSConfigurationParameter convert2InternalId(IN const BTSEvoConfigIdEnum configId) const;

   uint16_t convertPageTimeout2Evolution(IN const uint16_t data) const;

   uint16_t convertPageTimeout2Internal(IN const uint16_t data) const;

   void addRequestedData(OUT ::std::map< BTSConfigurationParameter, uint64_t >& requestedDataList, IN const BTSConfigurationParameter configurationParameter, IN const uint64_t data) const;

   void delRequestedData(OUT ::std::map< BTSConfigurationParameter, uint64_t >& requestedDataList, IN const BTSConfigurationParameter configurationParameter) const;

   uint64_t getRequestedIntData(IN const ::std::map< BTSConfigurationParameter, uint64_t >& requestedDataList, IN const BTSConfigurationParameter configurationParameter) const;

   void createBtApplReadConfigurationReq(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId) const;

   void createBtApplSetConfigurationReq(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId, IN const BTSEvoConfigDataStream& data) const;

   Ipc2Bts_BaseMessage* createVirtualBtApplSetConfigurationCfmMsg(IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId, IN const BTSIpcCommonErrorCode errorCode) const;
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_BASIC_CONFIGURATION_ALPS_EVOLUTION_EXT_H_
