/**
 * @file AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop DBUS Callback for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop DBUS Callback implementation for ObjectManager.
 */

#include "AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "TraceClasses.h"
#include "FwAssert.h"
#include "FwTrace.h"
#include "cc_dbus_if/EvolutionGeniviDbusParser.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BTS_DBUS
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf.cpp.trc.h"
#endif
#endif

using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;

namespace btstackif {
namespace genivi {
namespace alpsevolutionext {

AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf(IDbusRecHandler* recHandler) :
DbusCallbackIf(recHandler),
_callbackId(0),
_leDeviceSendIf(0),
_leSeamlessPairingSendIf(0)
{
}

AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::~AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf()
{
   _leDeviceSendIf = 0;
   _leSeamlessPairingSendIf = 0;
}

// "ServiceAvailableIF" implementation --- start
void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::onAvailableCb(const bool available, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const ::ccdbusif::DbusBusType busType /*= ::ccdbusif::BUS_TYPE_SYSTEM*/)
{
   BTSDbusServiceAvailability availabilityEvent(BTS_DBUS_SERVICE_NOT_AVAILABLE);

   if(true == available)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   // check for BLE
   if(::ccdbusif::BUS_TYPE_SYSTEM == busType)
   {
      Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

      if(0 != ptrMsg)
      {
         ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_BLE_OBJECT_MANAGER_SYSTEM);
         ptrMsg->setAvailabilityEvent(availabilityEvent);
         ptrMsg->setBusType(busType);
         ptrMsg->setBusName(busName);
         ptrMsg->setObjPath(objPath);
      }
      onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
   }
}

void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::onUnavailableCb(const bool available, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const ::ccdbusif::DbusBusType busType /*= ::ccdbusif::BUS_TYPE_SYSTEM*/)
{
   BTSDbusServiceAvailability availabilityEvent(BTS_DBUS_SERVICE_NOT_AVAILABLE);

   if(true == available)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   // check for BLE
   if(::ccdbusif::BUS_TYPE_SYSTEM == busType)
   {
      Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

      if(0 != ptrMsg)
      {
         ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_BLE_OBJECT_MANAGER_SYSTEM);
         ptrMsg->setAvailabilityEvent(availabilityEvent);
         ptrMsg->setBusType(busType);
         ptrMsg->setBusName(busName);
         ptrMsg->setObjPath(objPath);
      }
      onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
   }
}
// "ServiceAvailableIF" implementation --- end

// /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- start
void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::onGetManagedObjectsErrorCb(const ::boost::shared_ptr< GetManagedObjectsError >& error, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const ::ccdbusif::DbusBusType busType /*= ::ccdbusif::BUS_TYPE_SYSTEM*/, const ::std::string& interfaceName /*= ::std::string()*/)
{
   // not used
   (void)(error);
   (void)(objPath);
   (void)(busName);
   (void)(busType);
   (void)(interfaceName);
}

void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::onGetManagedObjectsResponseCb(const ::boost::shared_ptr< GetManagedObjectsResponse >& response, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const ::ccdbusif::DbusBusType busType /*= ::ccdbusif::BUS_TYPE_SYSTEM*/, const ::std::string& interfaceName /*= ::std::string()*/)
{
   // not used
   (void)(response);
   (void)(objPath);
   (void)(busName);
   (void)(busType);
   (void)(interfaceName);
}

void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::onInterfacesAddedErrorCb(const ::boost::shared_ptr< InterfacesAddedError >& error, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const ::ccdbusif::DbusBusType busType /*= ::ccdbusif::BUS_TYPE_SYSTEM*/, const ::std::string& interfaceName /*= ::std::string()*/)
{
   // not used
   (void)(error);
   (void)(objPath);
   (void)(busName);
   (void)(busType);
   (void)(interfaceName);
}

void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::onInterfacesAddedSignalCb(const ::boost::shared_ptr< InterfacesAddedSignal >& signal, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const ::ccdbusif::DbusBusType busType /*= ::ccdbusif::BUS_TYPE_SYSTEM*/, const ::std::string& interfaceName /*= ::std::string()*/)
{
   (void)(objPath);
   (void)(busName);
   (void)(busType);
   (void)(interfaceName);

   // HINT: proxy object delivers following data:
   //    busName
   //    objPath
   //    interfaceName
   //    busType

   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   // parser.parseInterfacesAdded(signal->getObject(), signal->getInterfacesMutable(), busType, busName, objPath, interfaceName);
   // parser.setTraces(false);

   ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& inInterfaces = signal->getInterfacesMutable();
   for(::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >::iterator it = inInterfaces.begin(); it != inInterfaces.end(); ++it)
   {
      if(parser.getInterface2String(::ccdbusif::evolution::IF_LE_ADAPTER) == it->first)
      {
         if((0 != _leDeviceSendIf) && (0 != _leSeamlessPairingSendIf))
         {
            // TODO
         }
      }
      else if(parser.getInterface2String(::ccdbusif::evolution::IF_LE_DEVICE) == it->first)
      {
         if((0 != _leDeviceSendIf) && (0 != _leSeamlessPairingSendIf))
         {
            // TODO
         }
      }
      else if(parser.getInterface2String(::ccdbusif::evolution::IF_LE_SEAMLESS_PAIRING) == it->first)
      {
         if((0 != _leDeviceSendIf) && (0 != _leSeamlessPairingSendIf))
         {
            // TODO
         }
      }
   }
}

void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::onInterfacesRemovedErrorCb(const ::boost::shared_ptr< InterfacesRemovedError >& error, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const ::ccdbusif::DbusBusType busType /*= ::ccdbusif::BUS_TYPE_SYSTEM*/, const ::std::string& interfaceName /*= ::std::string()*/)
{
   // not used
   (void)(error);
   (void)(objPath);
   (void)(busName);
   (void)(busType);
   (void)(interfaceName);
}

void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::onInterfacesRemovedSignalCb(const ::boost::shared_ptr< InterfacesRemovedSignal >& signal, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const ::ccdbusif::DbusBusType busType /*= ::ccdbusif::BUS_TYPE_SYSTEM*/, const ::std::string& interfaceName /*= ::std::string()*/)
{
   (void)(objPath);
   (void)(busName);
   (void)(busType);
   (void)(interfaceName);

   // HINT: proxy object delivers following data:
   //    objPath
   //    busName
   //    busType
   //    interfaceName

   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   const ::std::vector< ::std::string >& removedInterfaces = signal->getInterfaces();

   parser.setTraces(true);
   // parser.parseInterfacesRemoved(signal->getObject(), removedInterfaces, busType, busName, objPath, interfaceName);
   // parser.setTraces(false);

   for(size_t i = 0; i < removedInterfaces.size(); ++i)
   {
      if(parser.getInterface2String(::ccdbusif::evolution::IF_LE_ADAPTER) == removedInterfaces[i])
      {
         if((0 != _leDeviceSendIf) && (0 != _leSeamlessPairingSendIf))
         {
            // TODO
         }
      }
      else if(parser.getInterface2String(::ccdbusif::evolution::IF_LE_DEVICE) == removedInterfaces[i])
      {
         if((0 != _leDeviceSendIf) && (0 != _leSeamlessPairingSendIf))
         {
            // TODO
         }
      }
      else if(parser.getInterface2String(::ccdbusif::evolution::IF_LE_SEAMLESS_PAIRING) == removedInterfaces[i])
      {
         if((0 != _leDeviceSendIf) && (0 != _leSeamlessPairingSendIf))
         {
            // TODO
         }
      }
   }
}
// /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- end

} //alpsevolutionext
} //genivi
} //btstackif
