/**
 * @file IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop DBUS Callback Interface for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for OrgFreedesktop DBUS callback for ObjectManager.
 */

#ifndef _I_ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
#define _I_ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_

#include "cc_dbus_if/IOrgFreedesktopDbusObjectManagerCallbackIf.h"

using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;

// class forward declarations
namespace ccdbusif {
class IEvolutionGeniviDbusLEDeviceSendRequestIf;
class IEvolutionGeniviDbusLESeamlessPairingSendRequestIf;
} //ccdbusif

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {
namespace alpsevolutionext {

/**
 * Callback interface class for ObjectManager.
 */
class IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf : public ::ccdbusif::IOrgFreedesktopDbusObjectManagerCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- start
   virtual void onGetManagedObjectsErrorCb(const ::boost::shared_ptr< GetManagedObjectsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onGetManagedObjectsResponseCb(const ::boost::shared_ptr< GetManagedObjectsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfacesAddedErrorCb(const ::boost::shared_ptr< InterfacesAddedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfacesAddedSignalCb(const ::boost::shared_ptr< InterfacesAddedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfacesRemovedErrorCb(const ::boost::shared_ptr< InterfacesRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfacesRemovedSignalCb(const ::boost::shared_ptr< InterfacesRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- end

   /**
    * Set receive handler.
    *
    * @param[in] handler: receive handler
    */
   virtual void setReceiveHandler(IDbusRecHandler* handler) = 0;

   /**
    * Set callback id.
    *
    * @param[in] callbackId: callback id
    */
   virtual void setCallbackId(const unsigned int callbackId) = 0;

   /**
    * Get callback id.
    *
    * @return = callback id
    */
   virtual unsigned int getCallbackId(void) const = 0;

   /**
    * Set LE device handler.
    *
    * @param[in] leDeviceSendIf: LE device handler
    */
   virtual void setLEDeviceSendIf(::ccdbusif::IEvolutionGeniviDbusLEDeviceSendRequestIf* leDeviceSendIf) = 0;

   /**
    * Set seamless pairing handler.
    *
    * @param[in] leSeamlessPairingSendIf: seamless pairing handler
    */
   virtual void setLESeamlessPairingSendIf(::ccdbusif::IEvolutionGeniviDbusLESeamlessPairingSendRequestIf* leSeamlessPairingSendIf) = 0;
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_I_ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
