/**
 * @file AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop DBUS Callback for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop DBUS Callback for ObjectManager.
 */

#ifndef _ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
#define _ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_

#include "IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf.h"
#include "DbusCallbackIf.h"

using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;

namespace btstackif {
namespace genivi {
namespace alpsevolutionext {

/**
 * Callback class for ObjectManager.
 */
class AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf : public DbusCallbackIf, public IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf
{
public:
   /**
    * Constructor.
    *
    * @param[in] recHandler: receive handler
    */
   AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf(IDbusRecHandler* recHandler);

   /**
    * Destructor.
    */
   virtual ~AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);
   // "ServiceAvailableIF" implementation --- end

   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- start
   virtual void onGetManagedObjectsErrorCb(const ::boost::shared_ptr< GetManagedObjectsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onGetManagedObjectsResponseCb(const ::boost::shared_ptr< GetManagedObjectsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesAddedErrorCb(const ::boost::shared_ptr< InterfacesAddedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesAddedSignalCb(const ::boost::shared_ptr< InterfacesAddedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesRemovedErrorCb(const ::boost::shared_ptr< InterfacesRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesRemovedSignalCb(const ::boost::shared_ptr< InterfacesRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setCallbackId(const unsigned int callbackId);

   virtual unsigned int getCallbackId(void) const;

   virtual void setLEDeviceSendIf(::ccdbusif::IEvolutionGeniviDbusLEDeviceSendRequestIf* leDeviceSendIf);

   virtual void setLESeamlessPairingSendIf(::ccdbusif::IEvolutionGeniviDbusLESeamlessPairingSendRequestIf* leSeamlessPairingSendIf);

private:
   unsigned int _callbackId; /**< callback id */
   ::ccdbusif::IEvolutionGeniviDbusLEDeviceSendRequestIf* _leDeviceSendIf; /**< LE device handler */
   ::ccdbusif::IEvolutionGeniviDbusLESeamlessPairingSendRequestIf* _leSeamlessPairingSendIf; /**< seamless pairing handler */
};

/**
 * inline methods
 */
inline void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::setCallbackId(const unsigned int callbackId)
{
   _callbackId = callbackId;
}

inline unsigned int AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::getCallbackId(void) const
{
   return _callbackId;
}

inline void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::setLEDeviceSendIf(::ccdbusif::IEvolutionGeniviDbusLEDeviceSendRequestIf* leDeviceSendIf)
{
   _leDeviceSendIf = leDeviceSendIf;
}

inline void AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf::setLESeamlessPairingSendIf(::ccdbusif::IEvolutionGeniviDbusLESeamlessPairingSendRequestIf* leSeamlessPairingSendIf)
{
   _leSeamlessPairingSendIf = leSeamlessPairingSendIf;
}

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
