/**
 * @file AlpsEvolutionBluetoothLowEnergyDbusIf.h
 *
 * @par SW-Component
 * DBus Extension
 *
 * @brief Implementation of Alps Evolution Genivi Bluetooth low energy DBus interface extension.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Alps Evolution Genivi Bluetooth low energy DBus interface extension.
 */

#ifndef _ALPS_EVOLUTION_BLUETOOTH_LOW_ENERGY_DBUS_IF_H_
#define _ALPS_EVOLUTION_BLUETOOTH_LOW_ENERGY_DBUS_IF_H_

#include "IDbusIfHandler.h"
#include "EvolutionGeniviStackTypes.h"

// class forward declarations
namespace ccdbusif {
class ICcDbusIfControllerClient;
class IOrgFreedesktopDbusObjectManagerSendRequestIf;
class IPropertiesGetAllDbusSendRequestIf;
// Evolution sending
class IEvolutionGeniviDbusLEAdapterSendRequestIf;
class IEvolutionGeniviDbusLEDeviceSendRequestIf;
class IEvolutionGeniviDbusLESeamlessPairingSendRequestIf;
// Evolution callback
class IEvolutionGeniviDbusLEAdapterCallbackIf;
class IEvolutionGeniviDbusLEDeviceCallbackIf;
class IEvolutionGeniviDbusLESeamlessPairingCallbackIf;
} //ccdbusif

namespace btstackif {
namespace genivi {

// class forward declarations
class PropertiesGetAllDbusCallbackIf;

// Bts2IPC messages
class Bts2Ipc_CreateLeDevice;
class Bts2Ipc_RemoveLeDevice;
class Bts2Ipc_GetLeAdapterAddressType;
class Bts2Ipc_GetLeAdapterAddress;
class Bts2Ipc_GetLeAdapterAlias;
class Bts2Ipc_SetLeAdapterAlias;
class Bts2Ipc_GetLeAdapterAdvertisingTimeout;
class Bts2Ipc_SetLeAdapterAdvertisingTimeout;
class Bts2Ipc_GetLeAdapterDiscoverableMode;
class Bts2Ipc_SetLeAdapterDiscoverableMode;
class Bts2Ipc_GetLeAdapterAdvertisingData;
class Bts2Ipc_SetLeAdapterAdvertisingData;
class Bts2Ipc_GetLeAdapterAdvertiseEnable;
class Bts2Ipc_SetLeAdapterAdvertiseEnable;
class Bts2Ipc_LeDeviceDisconnect;
class Bts2Ipc_GetLeDeviceAddressType;
class Bts2Ipc_GetLeDeviceAddress;
class Bts2Ipc_GetLeDeviceConnected;
class Bts2Ipc_SendSeamlessPairingErrorCode;
class Bts2Ipc_SeamlessPairingAllowAccess;
class Bts2Ipc_GetSeamlessPairingPairingData;
class Bts2Ipc_SetSeamlessPairingPairingData;

namespace alpsevolutionext {

// class forward declarations
class IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf;

/**
 * Alps Evolution Genivi connection DBus interface class.
 */
class AlpsEvolutionBluetoothLowEnergyDbusIf : public IDbusIfHandler
{
public:
   /**
    * Default constructor.
    */
   AlpsEvolutionBluetoothLowEnergyDbusIf();

   /**
    * Destructor.
    */
   virtual ~AlpsEvolutionBluetoothLowEnergyDbusIf();

   virtual void setDbusBaseIf(IN IDbusBase* dbusBase);

   virtual void setDbusRecHandlerIf(IN IDbusRecHandler* dbusRecHandler);

   virtual void enable(IN const bool enable);

   virtual void initialize(void);

   virtual void destroy(void);

   virtual void setCcDbusIfControllerIf(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent, IN const BTSUserMode userMode,
            IN ::ccdbusif::ICcDbusIfController* controller, IN const ::std::vector< BTSDbusInterfaceItem >& dbusInterfaces, IN const BTSLocalConfigurationContainer& configuration);

   virtual void resetCcDbusIfControllerIf(void);

   virtual bool setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData);

   virtual bool setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData);

   virtual bool setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData);

   virtual bool sendMessage(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_BaseMessage* message);

   virtual bool createErrorMessage(OUT Ipc2Bts_BaseMessage** ipc2BtsMessage, IN const Bts2Ipc_BaseMessage* bts2IpcMessage, IN const BTSIpcCommonErrorCode errorCode) const;

   virtual bool transferMessageData(OUT Ipc2Bts_BaseMessage* ipc2BtsMessage, IN const Bts2Ipc_BaseMessage* bts2IpcMessage) const;

private:
   IDbusBase* _dbusBase; /**< DBus base interface */
   IDbusRecHandler* _dbusRecHandler; /**< DBus receive handler interface */
   bool _enabled; /**< enabled flag */
   bool _initialized; /**< initialized flag */

   // DBus access
   ::ccdbusif::ICcDbusIfControllerClient* _controllerClient; /**< DBus controller client */

   // general services
   ::ccdbusif::IOrgFreedesktopDbusObjectManagerSendRequestIf* _objectManagerIf; /**< DBus send interface */
   ::ccdbusif::IPropertiesGetAllDbusSendRequestIf* _propertiesGetAllIf; /**< DBus send interface */

   // send interfaces
   ::ccdbusif::IEvolutionGeniviDbusLEAdapterSendRequestIf* _adapterIf; /**< DBus send interface */
   ::ccdbusif::IEvolutionGeniviDbusLEDeviceSendRequestIf* _deviceIf; /**< DBus send interface */
   ::ccdbusif::IEvolutionGeniviDbusLESeamlessPairingSendRequestIf* _seamlessPairingIf; /**< DBus send interface */

   // general services
   IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf* _objectManagerCb; /**< DBus callback interface */
   PropertiesGetAllDbusCallbackIf* _propertiesGetAllCb; /**< DBus callback interface */

   // callback interfaces
   ::ccdbusif::IEvolutionGeniviDbusLEAdapterCallbackIf* _adapterCb; /**< DBus callback interface */
   ::ccdbusif::IEvolutionGeniviDbusLEDeviceCallbackIf* _deviceCb; /**< DBus callback interface */
   ::ccdbusif::IEvolutionGeniviDbusLESeamlessPairingCallbackIf* _seamlessPairingCb; /**< DBus callback interface */

   /**
    * Send given message.
    *
    * @param[out] deleteMsg: flag indicating whether given message shall be deleted or not
    * @param[out] sendErrorMsg: flag indicating whether error message shall be generated and sent (sending failed) or not
    * @param[in] message: message
    */
   void handleBts2IpcCreateLeDevice(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_CreateLeDevice* message) const;
   void handleBts2IpcRemoveLeDevice(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_RemoveLeDevice* message) const;
   void handleBts2IpcGetLeAdapterAddressType(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeAdapterAddressType* message) const;
   void handleBts2IpcGetLeAdapterAddress(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeAdapterAddress* message) const;
   void handleBts2IpcGetLeAdapterAlias(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeAdapterAlias* message) const;
   void handleBts2IpcSetLeAdapterAlias(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN const Bts2Ipc_SetLeAdapterAlias* message) const;
   void handleBts2IpcGetLeAdapterAdvertisingTimeout(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeAdapterAdvertisingTimeout* message) const;
   void handleBts2IpcSetLeAdapterAdvertisingTimeout(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN const Bts2Ipc_SetLeAdapterAdvertisingTimeout* message) const;
   void handleBts2IpcGetLeAdapterDiscoverableMode(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeAdapterDiscoverableMode* message) const;
   void handleBts2IpcSetLeAdapterDiscoverableMode(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN const Bts2Ipc_SetLeAdapterDiscoverableMode* message) const;
   void handleBts2IpcGetLeAdapterAdvertisingData(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeAdapterAdvertisingData* message) const;
   void handleBts2IpcSetLeAdapterAdvertisingData(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN const Bts2Ipc_SetLeAdapterAdvertisingData* message) const;
   void handleBts2IpcGetLeAdapterAdvertiseEnable(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeAdapterAdvertiseEnable* message) const;
   void handleBts2IpcSetLeAdapterAdvertiseEnable(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN const Bts2Ipc_SetLeAdapterAdvertiseEnable* message) const;
   void handleBts2IpcLeDeviceDisconnect(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_LeDeviceDisconnect* message) const;
   void handleBts2IpcGetLeDeviceAddressType(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeDeviceAddressType* message) const;
   void handleBts2IpcGetLeDeviceAddress(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeDeviceAddress* message) const;
   void handleBts2IpcGetLeDeviceConnected(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetLeDeviceConnected* message) const;
   void handleBts2IpcSendSeamlessPairingErrorCode(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_SendSeamlessPairingErrorCode* message) const;
   void handleBts2IpcSeamlessPairingAllowAccess(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_SeamlessPairingAllowAccess* message) const;
   void handleBts2IpcGetSeamlessPairingPairingData(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN Bts2Ipc_GetSeamlessPairingPairingData* message) const;
   void handleBts2IpcSetSeamlessPairingPairingData(OUT bool& deleteMsg, OUT bool& sendErrorMsg, IN const Bts2Ipc_SetSeamlessPairingPairingData* message) const;
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_ALPS_EVOLUTION_BLUETOOTH_LOW_ENERGY_DBUS_IF_H_
