/**
 * @file IStateMachine.h
 *
 * @par SW-Component
 * State machine
 *
 * @brief Interface definition for state machines.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the common interface for all state machines.
 */

#ifndef _I_STATE_MACHINE_H_
#define _I_STATE_MACHINE_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Bts2App_BaseMessage;

/**
 * Interface definition.
 */
class IStateMachine
{
public:
   /**
    * Destructor.
    */
   virtual ~IStateMachine() {}

   /**
    * Reset internal data.
    */
   virtual void reset(void) = 0;

   /**
    * Force initial state. All status information shall be reset to initial state. If this causes a transition or
    * an end of an ongoing action the related status/result information will be updated to client.
    * No request shall be sent to Bluetooth stack because this interface is triggered in case of error situation.
    *
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    */
   virtual void forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList) = 0;

   /**
    * Set blocking for IPC communication (BTS2IPC + IPC2BTS).
    *
    * @param[in] enable: block/unblock
    */
   virtual void setBlockingIpc(IN const bool enable) = 0;

   /**
    * Set blocking for APP communication (BTS2APP + APP2BTS).
    *
    * @param[in] enable: block/unblock
    */
   virtual void setBlockingApp(IN const bool enable) = 0;
};

} //btstackif

#endif //_I_STATE_MACHINE_H_
