/**
 * @file WblWiFiSetupStatusData.cpp
 *
 * @par SW-Component
 * State machine for WBL WiFi setup status
 *
 * @brief Implementation of WBL WiFi setup status data.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of WBL WiFi setup status data.
 */

#include "WblWiFiSetupStatusData.h"

namespace btstackif {

WblWiFiSetupStatusData::WblWiFiSetupStatusData() :
available(false),
status(),
supportedRestrictions(),
pending(),
connected(false),
healthinessIndicator(0)
{
}

WblWiFiSetupStatusData::~WblWiFiSetupStatusData()
{
}

WblWiFiSetupStatusData::WblWiFiSetupStatusData(const WblWiFiSetupStatusData& ref) :
available(ref.available),
status(ref.status),
supportedRestrictions(ref.supportedRestrictions),
pending(ref.pending),
connected(ref.connected),
healthinessIndicator(ref.healthinessIndicator)
{
}

WblWiFiSetupStatusData& WblWiFiSetupStatusData::operator=(const WblWiFiSetupStatusData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   available = ref.available;
   status = ref.status;
   supportedRestrictions = ref.supportedRestrictions;
   pending = ref.pending;
   connected = ref.connected;
   healthinessIndicator = ref.healthinessIndicator;

   return *this;
}

bool WblWiFiSetupStatusData::operator==(const WblWiFiSetupStatusData& ref) const
{
   bool result = true;

   result = (true == result) && (available == ref.available);
   result = (true == result) && (status == ref.status);
   result = (true == result) && (supportedRestrictions == ref.supportedRestrictions);
   result = (true == result) && (pending == ref.pending);
   result = (true == result) && (connected == ref.connected);
   result = (true == result) && (healthinessIndicator == ref.healthinessIndicator);

   return result;
}

bool WblWiFiSetupStatusData::operator!=(const WblWiFiSetupStatusData& ref) const
{
   return !(operator==(ref));
}

void WblWiFiSetupStatusData::reset(void)
{
   available = false;
   status.reset();
   supportedRestrictions.clear();
   pending.setData(0);
   connected = false;
   healthinessIndicator = 0;
}

} //btstackif
