/**
 * @file WblStartup.h
 *
 * @par SW-Component
 * State machine for WBL startup
 *
 * @brief Implementation of generic WBL startup state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of generic WBL startup state machine.
 */

#ifndef _WBL_STARTUP_H_
#define _WBL_STARTUP_H_

#include "StateMachine.h"
#include "IWblStartup.h"
#include "IWblStartupCallback.h"
//#include "IExtendedTimeoutHandler.h"

#include <set>

namespace btstackif {

/**
 * WblStartup class.
 */
class WblStartup : public StateMachine, public IWblStartup, public IWblStartupCallback/*, public IExtendedTimeoutHandler*/
{
public:
   /**
    * Default constructor.
    */
   WblStartup();

   /**
    * Destructor.
    */
   virtual ~WblStartup();

   virtual void reset(void);

   virtual void forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void setInstance(IN IWblStartupRequest* instance);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void setTimerPoolIf(IN ITimerPool* timerPool);

   virtual void sendInitializedStatus(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN BtStackIfCallback* user, IN const BTSSessionHandle handle, IN const BTSCommonEnumClass statusCode) const;

   virtual void sendInitializedStatus(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_TriggerFbWblInitialized& request, IN const BTSCommonEnumClass statusCode) const;

   virtual void sendServiceAvailabilityStatus(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN BtStackIfCallback* user, IN const BTSSessionHandle handle, IN const BTSCommonEnumClass statusCode) const;

   virtual void sendServiceAvailabilityStatus(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_GetWblServiceAvailability& request, IN const BTSCommonEnumClass statusCode) const;

   virtual bool getServiceAvailability(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_GetWblServiceAvailability& request);

   virtual bool processTriggerInitializedCallback(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_TriggerFbWblInitialized& request);

   virtual void processTriggerInitializedCallback(void);

   virtual bool isServiceAvailable(void) const;

   virtual bool isStartupOngoing(void) const;

   virtual void registerObserver(IN IWblStartupObserver* observer);

   virtual void informAboutInitialDataStatus(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const WblStartupData::InitialDataPendingBit pendingBit, IN const bool enable);

   virtual void updateServiceAvailability(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDbusServiceAvailability availability);

   // virtual void handleExtendedTimeout(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSTimerId timerId);

private:
   IWblStartupRequest* _requestIf; /**< request interface */
   IBasicControl* _controlIf; /**< basic control interface */
   ITimerPool* _timerPoolIf; /**< timer pool interface */
   BTSDbusServiceAvailability _availability; /**< availability of WBL service */
   bool _initializedDone; /**< flag for finished initialized sequence */
   ::std::set< IWblStartupObserver* > _observerList; /**< observer list */
   WblStartupData _startupData; /**< startup data */

   void createFbWblInitializedStatusMsg(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN BtStackIfCallback* user, IN const BTSSessionHandle handle, IN const bool sendStatusToAll, IN const BTSDbusServiceAvailability availability) const;

   void createWblServiceAvailabilityStatusMsg(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN BtStackIfCallback* user, IN const BTSSessionHandle handle, IN const bool sendStatusToAll, IN const BTSDbusServiceAvailability availability) const;

   void informObservers(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDbusServiceAvailability availability) const;
};

} //btstackif

#endif //_WBL_STARTUP_H_
