/**
 * @file IStartupCallback.h
 *
 * @par SW-Component
 * State machine for startup
 *
 * @brief Callback interface definition for startup state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the callback interface to be used by specific startup state machine.
 *          Callback interface must be provided by generic startup state machine.
 */

#ifndef _I_STARTUP_CALLBACK_H_
#define _I_STARTUP_CALLBACK_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

/**
 * Interface definition.
 */
class IStartupCallback
{
public:
   /**
    * Destructor.
    */
   virtual ~IStartupCallback() {}

   /**
    * Indicate start of startup sequence.
    *
    * @param[in] availability: service availability
    */
   virtual void startupSequenceStarted(IN const BTSDbusServiceAvailability availability) = 0;

   /**
    * Indicate service availability.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] availability: service availability
    * @param[in] reason: BT off reason
    */
   virtual void indicateAvailability(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDbusServiceAvailability availability, IN const BTSBluetoothOffReason reason = BTS_BT_OFF_REASON_NOT_VALID) = 0;

   /**
    * Get startup ongoing flag.
    *
    * @return = startup ongoing flag
    */
   virtual bool getStartupOngoingFlag(void) const = 0;
};

} //btstackif

#endif //_I_STARTUP_CALLBACK_H_
