/**
 * @file Rssi.h
 *
 * @par SW-Component
 * State machine for RSSI
 *
 * @brief Implementation of generic RSSI state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of generic RSSI + link quality state machine.
 */

#ifndef _RSSI_H_
#define _RSSI_H_

#include "StateMachine.h"
#include "IRssi.h"
#include "IRssiCallback.h"

namespace btstackif {

/**
 * RSSI class.
 */
class Rssi : public StateMachine, public IRssi, public IRssiCallback
{
public:
   /**
    * Default constructor.
    */
   Rssi();

   /**
    * Destructor.
    */
   virtual ~Rssi();

   virtual void reset(void);

   virtual void forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void setInstance(IN IRssiRequest* instance);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void setDeviceManagerIf(IN IDeviceManager* deviceManager);

   virtual IStateMachine* getSmEntryInterface(void);

   virtual void sendResult(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_RequestLinkQuality& request, IN const BTSCommonEnumClass resultCode) const;

   virtual bool isValidRequest(IN const App2Bts_RequestLinkQuality& request) const;

   virtual bool getLinkQuality(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_RequestLinkQuality& request);

   virtual void getLinkQualityResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSBDAddress& address, IN const bool success, IN const bool rssiSupported, IN const BTSRssi rssi, IN const bool linkQualitySupported, IN const BTSLinkQuality linkQuality);

   virtual App2Bts_BaseMessage* getApp2BtsWorkingMessage(void);

private:
   IRssiRequest* _requestIf; /**< request interface */
   IBasicControl* _controlIf; /**< basic control interface */
   IDeviceManager* _deviceManagerIf; /**< device manager interface */
   BTSApp2BtsMessageRequestItem _requestItem; /**< request item */
   BTSBDAddress _address; /**< BT device address */

   void handleActionFinished(OUT BTSHandleIpc2BtsMessageItem& messageItem);

   void createLinkQualityResultMsg(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN BtStackIfCallback* user, IN const BTSSessionHandle handle, IN const BTSBDAddress& address, IN const BTSRequestResult result, IN const BTSRssi rssi, IN const BTSLinkQuality linkQuality) const;
};

} //btstackif

#endif //_RSSI_H_
