/**
 * @file RestrictedPairingConnecting.h
 *
 * @par SW-Component
 * State machine for restricted pairing and connecting
 *
 * @brief Implementation of generic restricted pairing and connecting state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of generic restricted pairing and connecting state machine.
 */

#ifndef _RESTRICTED_PAIRING_CONNECTING_H_
#define _RESTRICTED_PAIRING_CONNECTING_H_

#include "StateMachine.h"
#include "IRestrictedPairingConnecting.h"

namespace btstackif {

/**
 * Restricted pairing and connecting class.
 */
class RestrictedPairingConnecting : public StateMachine, public IRestrictedPairingConnecting
{
public:
   /**
    * Default constructor.
    */
   RestrictedPairingConnecting();

   /**
    * Destructor.
    */
   virtual ~RestrictedPairingConnecting();

   virtual void reset(void);

   virtual void forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual IStateMachine* getSmEntryInterface(void);

   virtual void setRestrictionAndSendStatus(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_SetDeviceForRestrictedPairingConnecting& request);

   virtual bool isValidRequest(IN const App2Bts_SetDeviceForRestrictedPairingConnecting& request) const;

   virtual bool setRestriction(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const App2Bts_SetDeviceForRestrictedPairingConnecting& request);

   virtual bool isPairingRestricted(OUT BTSBDAddress& address) const;

   virtual bool isConnectingRestricted(OUT BTSBDAddress& address) const;

private:
   const bool _restrictedPairingSupported; /**< flag to indicate whether restricted pairing is supported or not */
   const bool _restrictedConnectingSupported; /**< flag to indicate whether restricted connecting is supported or not */
   BTSBDAddress _address; /**< device address */

   void createStatusMsg(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN BtStackIfCallback* user, IN const BTSSessionHandle handle, IN const BTSBDAddress& address) const;
};

} //btstackif

#endif //_RESTRICTED_PAIRING_CONNECTING_H_
