/**
 * @file IConfigurePageTimeout.h
 *
 * @par SW-Component
 * State machine for configure page timeout
 *
 * @brief Interface definition for configure page timeout state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the interface for configure page timeout state machine.
 */

#ifndef _I_CONFIGURE_PAGE_TIMEOUT_H_
#define _I_CONFIGURE_PAGE_TIMEOUT_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class IBasicConfiguration;
class IProtocolSmHelper;
class IConfiguration;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

/**
 * Interface definition.
 */
class IConfigurePageTimeout
{
public:
   /**
    * Destructor.
    */
   virtual ~IConfigurePageTimeout() {}

   /**
    * Set basic configuration interface.
    *
    * @param[in] basicConfigurationIf: basic configuration interface
    */
   virtual void setBasicConfigurationIf(IN IBasicConfiguration* basicConfigurationIf) = 0;

   /**
    * Set protocol SM helper.
    *
    * @param[in] helper: protocol SM helper interface
    */
   virtual void setProtocolSmHelper(IN IProtocolSmHelper* helper) = 0;

   /**
    * Reset state machine.
    */
   virtual void resetStateMachine(void) = 0;

   /**
    * Configure page timout.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[in] pageTimeout: page timeout
    * @param[in] configurationIf: configuration interface
    *
    * @return = true: configuration was started,
    * @return = false: configuration was not started, e.g. not necessary or not possible
    */
   virtual bool configure(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSTimeValue pageTimeout, IN const IConfiguration& configurationIf) = 0;
};

} //btstackif

#endif //_I_CONFIGURE_PAGE_TIMEOUT_H_
