/**
 * @file PairingData.cpp
 *
 * @par SW-Component
 * State machine for pairing
 *
 * @brief Implementation of pairing data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of pairing data.
 */

#include "PairingData.h"

namespace btstackif {

PairingData::PairingData() :
pairingOriginator(BTS_PAIR_CONNECT_INITIATED_LAST),
sspMode(BTS_SSP_LAST),
numValue(),
info(),
requestItem(),
createPending(false),
cancelRequested(false)
{
}

PairingData::~PairingData()
{
}

PairingData::PairingData(const PairingData& ref)
{
   pairingOriginator = ref.pairingOriginator;
   sspMode = ref.sspMode;
   numValue = ref.numValue;
   info = ref.info;
   requestItem = ref.requestItem;
   createPending = ref.createPending;
   cancelRequested = ref.cancelRequested;
}

PairingData& PairingData::operator=(const PairingData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   pairingOriginator = ref.pairingOriginator;
   sspMode = ref.sspMode;
   numValue = ref.numValue;
   info = ref.info;
   requestItem = ref.requestItem;
   createPending = ref.createPending;
   cancelRequested = ref.cancelRequested;

   return *this;
}

bool PairingData::operator==(const PairingData& ref) const
{
   bool result = true;

   result = (true == result) && (pairingOriginator == ref.pairingOriginator);
   result = (true == result) && (sspMode == ref.sspMode);
   result = (true == result) && (numValue == ref.numValue);
   result = (true == result) && (info == ref.info);
   result = (true == result) && (requestItem == ref.requestItem);
   result = (true == result) && (createPending == ref.createPending);
   result = (true == result) && (cancelRequested == ref.cancelRequested);

   return result;
}

bool PairingData::operator!=(const PairingData& ref) const
{
   return !(operator==(ref));
}

} //btstackif
