/**
 * @file ILocalBluetoothNameCallback.h
 *
 * @par SW-Component
 * State machine for setting local Bluetooth name
 *
 * @brief Callback interface definition for setting local Bluetooth name state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the callback interface to be used by specific setting local Bluetooth name state machine.
 *          Callback interface must be provided by generic setting local Bluetooth name state machine.
 */

#ifndef _I_LOCAL_BLUETOOTH_NAME_CALLBACK_H_
#define _I_LOCAL_BLUETOOTH_NAME_CALLBACK_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

/**
 * Interface definition.
 */
class ILocalBluetoothNameCallback
{
public:
   /**
    * Destructor.
    */
   virtual ~ILocalBluetoothNameCallback() {}

   /**
    * Update local name.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] name: local name
    * @param[in] success: success/failed flag
    */
   virtual void updateLocalName(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDeviceName& name, IN const bool success) = 0;

   /**
    * Set current BT stack value for local name.
    *
    * @param[in] name: local name
    */
   virtual void setBtStackName(IN const BTSDeviceName& name) = 0;
};

} //btstackif

#endif //_I_LOCAL_BLUETOOTH_NAME_CALLBACK_H_
