/**
 * @file ILinkKeyRequest.h
 *
 * @par SW-Component
 * State machine for link key
 *
 * @brief Request interface definition for link key state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the request interface to be implemented by specific link key state machine.
 */

#ifndef _I_LINK_KEY_REQUEST_H_
#define _I_LINK_KEY_REQUEST_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class ILinkKeyCallback;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

/**
 * Interface definition.
 */
class ILinkKeyRequest
{
public:
   /**
    * Destructor.
    */
   virtual ~ILinkKeyRequest() {}

   /**
    * Reset internal data.
    */
   virtual void reset(void) = 0;

   /**
    * Set callback instance (implementation).
    *
    * @param[in] callback: callback instance (implementation)
    */
   virtual void setCallback(IN ILinkKeyCallback* callback) = 0;

   /**
    * Set link key.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[in] address: device address
    * @param[in] linkKeyType: link key type
    * @param[in] linkKey: link key
    * @param[in] dLinkKey: double link key
    */
   virtual void setLinkKey(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSBDAddress& address, IN const BTSLinkKeyType linkKeyType, IN const BTSLinkKey& linkKey, IN const BTSDLinkKey& dLinkKey) = 0;
};

} //btstackif

#endif //_I_LINK_KEY_REQUEST_H_
