/**
 * @file ILinkKeyCallback.h
 *
 * @par SW-Component
 * State machine for link key
 *
 * @brief Callback interface definition for link key state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the callback interface to be used by specific link key state machine.
 *          Callback interface must be provided by generic link key state machine.
 */

#ifndef _I_LINK_KEY_CALLBACK_H_
#define _I_LINK_KEY_CALLBACK_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

/**
 * Interface definition.
 */
class ILinkKeyCallback
{
public:
   /**
    * Destructor.
    */
   virtual ~ILinkKeyCallback() {}

   /**
    * Indicate link key request.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] address: device address
    */
   virtual void indicateLinkKeyRequest(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSBDAddress& address) = 0;
};

} //btstackif

#endif //_I_LINK_KEY_CALLBACK_H_
