/**
 * @file InquiryData.h
 *
 * @par SW-Component
 * State machine for inquiry
 *
 * @brief Implementation of inquiry data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of inquiry data.
 */

#ifndef _INQUIRY_DATA_H_
#define _INQUIRY_DATA_H_

#include "BtStackInternalTypes.h"
#include "ExtendedTimerEntry.h"

namespace btstackif {

/**
 * Inquiry data class.
 */
class InquiryData
{
public:
   /**
    * Default constructor.
    */
   InquiryData();

   /**
    * Destructor.
    */
   virtual ~InquiryData();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   InquiryData(const InquiryData& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   InquiryData& operator=(const InquiryData& ref);

   /**
    * Equality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator==(const InquiryData& ref) const;

   /**
    * Inequality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator!=(const InquiryData& ref) const;

   // member with public access
   BTSDeviceName name; /**< device name */
};

} //btstackif

#endif //_INQUIRY_DATA_H_
