/**
 * @file HfpDeviceCapabilitiesData.cpp
 *
 * @par SW-Component
 * State machine for HFP device capabilities
 *
 * @brief Implementation of HFP device capabilities data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of HFP device capabilities data.
 */

#include "HfpDeviceCapabilitiesData.h"

namespace btstackif {

HfpDeviceCapabilitiesData::HfpDeviceCapabilitiesData() :
modemAdded(false),
modemAvailable(false),
hfInterfaceAdded(false),
hfInterfaceAvailable(false),
ringtoneSupported(false),
ringtoneEnabled(false),
ringtoneDataAvailable()
{
}

HfpDeviceCapabilitiesData::~HfpDeviceCapabilitiesData()
{
}

HfpDeviceCapabilitiesData::HfpDeviceCapabilitiesData(const HfpDeviceCapabilitiesData& ref) :
modemAdded(ref.modemAdded),
modemAvailable(ref.modemAvailable),
hfInterfaceAdded(ref.hfInterfaceAdded),
hfInterfaceAvailable(ref.hfInterfaceAvailable),
ringtoneSupported(ref.ringtoneSupported),
ringtoneEnabled(ref.ringtoneEnabled),
ringtoneDataAvailable(ref.ringtoneDataAvailable)
{
}

HfpDeviceCapabilitiesData& HfpDeviceCapabilitiesData::operator=(const HfpDeviceCapabilitiesData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   modemAdded = ref.modemAdded;
   modemAvailable = ref.modemAvailable;
   hfInterfaceAdded = ref.hfInterfaceAdded;
   hfInterfaceAvailable = ref.hfInterfaceAvailable;
   ringtoneSupported = ref.ringtoneSupported;
   ringtoneEnabled = ref.ringtoneEnabled;
   ringtoneDataAvailable = ref.ringtoneDataAvailable;

   return *this;
}

bool HfpDeviceCapabilitiesData::operator==(const HfpDeviceCapabilitiesData& ref) const
{
   bool result = true;

   result = (true == result) && (modemAdded == ref.modemAdded);
   result = (true == result) && (modemAvailable == ref.modemAvailable);
   result = (true == result) && (hfInterfaceAdded == ref.hfInterfaceAdded);
   result = (true == result) && (hfInterfaceAvailable == ref.hfInterfaceAvailable);
   result = (true == result) && (ringtoneSupported == ref.ringtoneSupported);
   result = (true == result) && (ringtoneEnabled == ref.ringtoneEnabled);
   result = (true == result) && (ringtoneDataAvailable == ref.ringtoneDataAvailable);

   return result;
}

bool HfpDeviceCapabilitiesData::operator!=(const HfpDeviceCapabilitiesData& ref) const
{
   return !(operator==(ref));
}

} //btstackif
