/**
 * @file IHfpDeviceCapabilities.h
 *
 * @par SW-Component
 * State machine for HFP device capabilities
 *
 * @brief Interface definition for generic HFP device capabilities state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the generic interface for HFP device capabilities state machine.
 */

#ifndef _I_HFP_DEVICE_CAPABILITIES_H_
#define _I_HFP_DEVICE_CAPABILITIES_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class IHfpDeviceCapabilitiesRequest;
class IBasicControl;
class IStateMachine;

/**
 * Interface definition.
 */
class IHfpDeviceCapabilities
{
public:
   /**
    * Destructor.
    */
   virtual ~IHfpDeviceCapabilities() {}

   /**
    * Set specific instance (implementation).
    *
    * @param[in] instance: instance (implementation)
    */
   virtual void setInstance(IN IHfpDeviceCapabilitiesRequest* instance) = 0;

   /**
    * Set basic control interface.
    *
    * @param[in] control: basic control interface
    */
   virtual void setControlIf(IN IBasicControl* control) = 0;

   /**
    * Get SM entry interface.
    *
    * @return = SM entry interface
    */
   virtual IStateMachine* getSmEntryInterface(void) = 0;
};

} //btstackif

#endif //_I_HFP_DEVICE_CAPABILITIES_H_
