/**
 * @file BasicConfigurationData.cpp
 *
 * @par SW-Component
 * State machine for basic configuration
 *
 * @brief Implementation of basic configuration data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of basic configuration data.
 */

#include "BasicConfigurationData.h"

namespace btstackif {

BasicConfigurationData::BasicConfigurationData() :
requestIf(0),
configRequestOngoing(false),
getRequestOngoing(false),
configRequestDone(false),
configItem(0),
beforeBtOn(false),
configureDuringStartup(false),
callback(0)
{
}

BasicConfigurationData::~BasicConfigurationData()
{
   requestIf = 0;
   configItem = 0;
   callback = 0;
}

BasicConfigurationData::BasicConfigurationData(const BasicConfigurationData& ref) :
requestIf(ref.requestIf),
configRequestOngoing(ref.configRequestOngoing),
getRequestOngoing(ref.getRequestOngoing),
configRequestDone(ref.configRequestDone),
configItem(ref.configItem),
beforeBtOn(ref.beforeBtOn),
configureDuringStartup(ref.configureDuringStartup),
callback(ref.callback)
{
}

BasicConfigurationData& BasicConfigurationData::operator=(const BasicConfigurationData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   requestIf = ref.requestIf;
   configRequestOngoing = ref.configRequestOngoing;
   getRequestOngoing = ref.getRequestOngoing;
   configRequestDone = ref.configRequestDone;
   configItem = ref.configItem;
   beforeBtOn = ref.beforeBtOn;
   configureDuringStartup = ref.configureDuringStartup;
   callback = ref.callback;

   return *this;
}

bool BasicConfigurationData::operator==(const BasicConfigurationData& ref) const
{
   bool result = true;

   result = (true == result) && (requestIf == ref.requestIf);
   result = (true == result) && (configRequestOngoing == ref.configRequestOngoing);
   result = (true == result) && (getRequestOngoing == ref.getRequestOngoing);
   result = (true == result) && (configRequestDone == ref.configRequestDone);
   result = (true == result) && (configItem == ref.configItem);
   result = (true == result) && (beforeBtOn == ref.beforeBtOn);
   result = (true == result) && (configureDuringStartup == ref.configureDuringStartup);
   result = (true == result) && (callback == ref.callback);

   return result;
}

bool BasicConfigurationData::operator!=(const BasicConfigurationData& ref) const
{
   return !(operator==(ref));
}

} //btstackif
