/**
 * @file BluetoothStackErrorHandling.h
 *
 * @par SW-Component
 * State machine for Bluetooth stack error handling
 *
 * @brief Implementation of generic Bluetooth stack error handling state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of generic Bluetooth stack error handling state machine.
 */

#ifndef _BLUETOOTH_STACK_ERROR_HANDLING_H_
#define _BLUETOOTH_STACK_ERROR_HANDLING_H_

#include "StateMachine.h"
#include "IBluetoothStackErrorHandling.h"
#include "IBluetoothStackErrorHandlingCallback.h"

namespace btstackif {

/**
 * BluetoothStackErrorHandling class.
 */
class BluetoothStackErrorHandling : public StateMachine, public IBluetoothStackErrorHandling, public IBluetoothStackErrorHandlingCallback
{
public:
   /**
    * Default constructor.
    */
   BluetoothStackErrorHandling();

   /**
    * Destructor.
    */
   virtual ~BluetoothStackErrorHandling();

   virtual void reset(void);

   virtual void forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void setInstance(IN IBluetoothStackErrorHandlingRequest* instance);

   virtual void setControlIf(IN IBasicControl* control);

   virtual IStateMachine* getSmEntryInterface(void);

   virtual void handleCriticalError(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const ::std::string& stackType, IN const ::std::string& errorType, IN const ::std::string& errorMessage, IN const bool doReset);

   virtual void handleGeneralError(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const ::std::string& stackType, IN const ::std::string& errorType, IN const ::std::string& errorMessage);

   virtual void handleDebugTrace(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const ::std::string& stackType, IN const ::std::string& errorType, IN const ::std::string& errorMessage, IN const bool writeToErrorMemory);

   virtual void handleOtherError(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const ::std::string& stackType, IN const ::std::string& errorType, IN const ::std::string& errorMessage);

private:
   IBluetoothStackErrorHandlingRequest* _requestIf; /**< request interface */
   IBasicControl* _controlIf; /**< basic control interface */
   const ::std::string _errMemHeader; /**< header part of error memory entry */

   void handleError(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const ::std::string& stackType, IN const ::std::string& errorType, IN const ::std::string& errorMessage, IN const bool doReset, IN const bool writeToErrorMemory);
};

} //btstackif

#endif //_BLUETOOTH_STACK_ERROR_HANDLING_H_
