/**
 * @file BtStackIfTelephonyRequest.cpp
 *
 * @par SW-Component
 * Interface
 *
 * @brief Telephony request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of telephony request functionality.
 */

#include "BtStackIfTelephonyRequest.h"
#include "App2Bts_MessageWrapper.h"
#include "BtsUtils.h"
#include "FwAssert.h"

namespace btstackif {

BtStackIfTelephonyRequest::BtStackIfTelephonyRequest(IN const BTSFunctionBlock componentFunctionBlock /*= BTS_FB_TELEPHONY*/, IN const BTSInterfaceType stackInterface /*= BTS_IF_ALPS_EVOLUTION_GENIVI*/) :
BtStackIfBaseRequest(BTS_USER_MODE_TELEPHONY, componentFunctionBlock, BTS_FB_TELEPHONY, stackInterface)
{
}

BtStackIfTelephonyRequest::BtStackIfTelephonyRequest() :
BtStackIfBaseRequest(BTS_USER_MODE_TELEPHONY, BTS_FB_TELEPHONY, BTS_FB_TELEPHONY, BTS_IF_ALPS_EVOLUTION_GENIVI)
{
   // shall not be used
   FW_NORMAL_ASSERT_ALWAYS();
}

BtStackIfTelephonyRequest::~BtStackIfTelephonyRequest()
{
}

void BtStackIfTelephonyRequest::registerCallback(IBtStackIfTelephonyCallback* callback)
{
   if(0 == callback)
   {
      return;
   }

   if(_callback.getTelephonyCallback())
   {
      // already registered
      return;
   }

   _callback.setTelephonyCallback(callback);
   registerInternalCallback();
}

BTSSessionHandle BtStackIfTelephonyRequest::getSessionHandle(void) const
{
   return getHandle();
}

BTSErrorCode BtStackIfTelephonyRequest::init(IN const BTSLocalTelephonyConfiguration& configuration) const
{
   BTSLocalConfigurationContainer container;
   container.telephonyConfiguration = configuration;
   container.telephonyActive = true;
   return processInit(container);
}

BTSErrorCode BtStackIfTelephonyRequest::deInit(void) const
{
   return processDeInit();
}

void BtStackIfTelephonyRequest::setTelephonyDummy(void)
{
   App2Bts_SetTelephonyDummy* ptrMessage = ptrNew_App2Bts_SetTelephonyDummy();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfTelephonyRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfTelephonyRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfTelephonyRequest::setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfTelephonyRequest::setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processMainControlTestCommand(testCommand, testData);
}

void BtStackIfTelephonyRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

void BtStackIfTelephonyRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

} //btstackif
