/**
 * @file BtStackIfInterface.cpp
 *
 * @par SW-Component
 * Interface
 *
 * @brief Bluetooth stack interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details General Bluetooth stack interface implementation.
 * This file contains only the interface implementation itself.
 * This file is completely generated by parser tooling (code generation).
 */
#if 0
#include "BtStackIf.h"
#include "IGenericStackIf.h"
#include "BtsUtils.h"

/**************************************************************************/
/***--- start of generated code ---****************************************/
BTSErrorCode BtStackIf::setDummy(IN const BTSBDAddress& localDeviceAddress, IN const BTSBDAddress& remoteDeviceAddress)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(localDeviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      if(true != isValidBdAddress(remoteDeviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->setDummy(localDeviceAddress, remoteDeviceAddress, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::switchBluetoothOnOff(IN const BTSBluetoothMode bluetoothMode, IN const BTSAdapterMode adapterMode)
{
   if(_genericStackIf)
   {
      return _genericStackIf->switchBluetoothOnOff(bluetoothMode, adapterMode, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::getBluetoothOnOffStatus(void)
{
   if(_genericStackIf)
   {
      return _genericStackIf->getBluetoothOnOffStatus(this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::switchBluetoothHardwareOnOff(IN const BTSBluetoothMode bluetoothMode)
{
   if(_genericStackIf)
   {
      return _genericStackIf->switchBluetoothHardwareOnOff(bluetoothMode, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::setLocalBtName(IN const BTSDeviceName& adapterName)
{
   if(_genericStackIf)
   {
      return _genericStackIf->setLocalBtName(adapterName, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::getLocalBtName(void)
{
   if(_genericStackIf)
   {
      return _genericStackIf->getLocalBtName(this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::setDeviceIdServiceRecord(IN const BTSDeviceIdServiceRecord& serviceRecord)
{
   if(_genericStackIf)
   {
      return _genericStackIf->setDeviceIdServiceRecord(serviceRecord, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::setDeviceForRestrictedPairingConnecting(IN const BTSBDAddress& expectedDeviceAddress, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(expectedDeviceAddress))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->setDeviceForRestrictedPairingConnecting(expectedDeviceAddress, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::setLocalAdapterModes(IN const BTSLocalMode discoverableMode, IN const BTSDiscoverableTimeout discoverableTimeout, IN const BTSLocalMode connectableMode, IN const BTSConnectableTimeout connectableTimeout, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      return _genericStackIf->setLocalAdapterModes(discoverableMode, discoverableTimeout, connectableMode, connectableTimeout, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::getLocalAdapterModes(IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      return _genericStackIf->getLocalAdapterModes(sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::startDiscovery(IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      return _genericStackIf->startDiscovery(sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::stopDiscovery(IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      return _genericStackIf->stopDiscovery(sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::getDiscoveringStatus(IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      return _genericStackIf->getDiscoveringStatus(sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::startPairing(IN const BTSBDAddress& deviceAddress, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->startPairing(deviceAddress, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::cancelPairing(IN const BTSBDAddress& deviceAddress, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->cancelPairing(deviceAddress, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::setPinCode(IN const BTSBDAddress& deviceAddress, IN const BTSPinCode& pinCode, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      if(true != isValidPinCode(pinCode))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->setPinCode(deviceAddress, pinCode, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::confirmSecureSimplePairing(IN const BTSBDAddress& deviceAddress, IN const BTSSspMode sspMode, IN const BTSNumericValue& numericValue, IN const BTSConfirmationMode confirmationMode, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      if(true != isValidNumericValue(numericValue))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->confirmSecureSimplePairing(deviceAddress, sspMode, numericValue, confirmationMode, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::setLinkKey(IN const BTSBDAddress& deviceAddress, IN const BTSLinkKeyType linkKeyType, IN const BTSLinkKey& linkKey, IN const BTSDLinkKey& dLinkKey, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      if(true != isValidLinkKey(linkKey))
      {
         return BTS_INVALID_PARAM;
      }

      if(true != isValidDLinkKey(dLinkKey))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->setLinkKey(deviceAddress, linkKeyType, linkKey, dLinkKey, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::connectProtocol(IN const BTSBDAddress& deviceAddress, IN const BTSProtocolId protocolId, IN const BTSUuid& sppUuid, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      if(true != isValidUuid(sppUuid))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->connectProtocol(deviceAddress, protocolId, sppUuid, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::acceptRemoteProtocolConnect(IN const BTSBDAddress& deviceAddress, IN const BTSProtocolId protocolId, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->acceptRemoteProtocolConnect(deviceAddress, protocolId, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::rejectRemoteProtocolConnect(IN const BTSBDAddress& deviceAddress, IN const BTSProtocolId protocolId, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->rejectRemoteProtocolConnect(deviceAddress, protocolId, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::disconnectProtocol(IN const BTSBDAddress& deviceAddress, IN const BTSProtocolId protocolId, IN const BTSUuid& sppUuid, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      if(true != isValidUuid(sppUuid))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->disconnectProtocol(deviceAddress, protocolId, sppUuid, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::disconnectDevice(IN const BTSBDAddress& deviceAddress, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->disconnectDevice(deviceAddress, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::getProtocolConnectionStatus(IN const BTSBDAddress& deviceAddress, IN const BTSProtocolId protocolId, IN const BTSUuid& sppUuid, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      if(true != isValidUuid(sppUuid))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->getProtocolConnectionStatus(deviceAddress, protocolId, sppUuid, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::getDeviceConnectionStatus(IN const BTSBDAddress& deviceAddress, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->getDeviceConnectionStatus(deviceAddress, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::startRemoteServiceSearch(IN const BTSBDAddress& deviceAddress, IN const BTSSearchType searchType, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->startRemoteServiceSearch(deviceAddress, searchType, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::cancelRemoteServiceSearch(IN const BTSBDAddress& deviceAddress, IN const BTSSearchType searchType, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->cancelRemoteServiceSearch(deviceAddress, searchType, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::queryRemoteName(IN const BTSBDAddress& deviceAddress, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->queryRemoteName(deviceAddress, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::requestLinkQuality(IN const BTSBDAddress& deviceAddress, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->requestLinkQuality(deviceAddress, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::startTestMode(IN const BTSBDAddress& deviceAddress, IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      if(true != isValidBdAddress(deviceAddress, false))
      {
         return BTS_INVALID_PARAM;
      }

      return _genericStackIf->startTestMode(deviceAddress, sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::stopTestMode(IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      return _genericStackIf->stopTestMode(sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

BTSErrorCode BtStackIf::requestTestModeLinkQuality(IN const BTSSessionHandle sessionHandle)
{
   if(_genericStackIf)
   {
      return _genericStackIf->requestTestModeLinkQuality(sessionHandle, this);
   }
   else
   {
      return BTS_LIB_NOT_INITIALIZED;
   }
}

/***--- end of generated code ---******************************************/
/**************************************************************************/
#endif
