/**
 * @file BtStackIfEcnrRequest.cpp
 *
 * @par SW-Component
 * Interface
 *
 * @brief Ecnr request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of ecnr request functionality.
 */

#include "BtStackIfEcnrRequest.h"
#include "App2Bts_MessageWrapper.h"
#include "BtsUtils.h"
#include "FwAssert.h"

namespace btstackif {

BtStackIfEcnrRequest::BtStackIfEcnrRequest(IN const BTSFunctionBlock componentFunctionBlock /*= BTS_FB_ECNR*/, IN const BTSInterfaceType stackInterface /*= BTS_IF_ALPS_EVOLUTION_GENIVI*/) :
BtStackIfBaseRequest(BTS_USER_MODE_TELEPHONY, componentFunctionBlock, BTS_FB_ECNR, stackInterface)
{
}

BtStackIfEcnrRequest::BtStackIfEcnrRequest() :
BtStackIfBaseRequest(BTS_USER_MODE_TELEPHONY, BTS_FB_ECNR, BTS_FB_ECNR, BTS_IF_ALPS_EVOLUTION_GENIVI)
{
   // shall not be used
   FW_NORMAL_ASSERT_ALWAYS();
}

BtStackIfEcnrRequest::~BtStackIfEcnrRequest()
{
}

void BtStackIfEcnrRequest::registerCallback(IBtStackIfEcnrCallback* callback)
{
   if(0 == callback)
   {
      return;
   }

   if(_callback.getEcnrCallback())
   {
      // already registered
      return;
   }

   _callback.setEcnrCallback(callback);
   registerInternalCallback();
}

BTSSessionHandle BtStackIfEcnrRequest::getSessionHandle(void) const
{
   return getHandle();
}

BTSErrorCode BtStackIfEcnrRequest::init(IN const BTSLocalEcnrConfiguration& configuration) const
{
   BTSLocalConfigurationContainer container;
   container.ecnrConfiguration = configuration;
   container.ecnrActive = true;
   return processInit(container);
}

BTSErrorCode BtStackIfEcnrRequest::deInit(void) const
{
   return processDeInit();
}

void BtStackIfEcnrRequest::setEcnrDummy(void)
{
   App2Bts_SetEcnrDummy* ptrMessage = ptrNew_App2Bts_SetEcnrDummy();
   if(ptrMessage)
   {
      ptrMessage->setCallback(&_callback);
      ptrMessage->setComponent(_componentFunctionBlock);
      ptrMessage->setStackInterface(_stackInterface);

      processApp2BtsMsg(ptrMessage);
   }
}

void BtStackIfEcnrRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfEcnrRequest::setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfEcnrRequest::setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const
{
   processSimulationTestCommand(testCommand, testData);
}

void BtStackIfEcnrRequest::setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processMainControlTestCommand(testCommand, testData);
}

void BtStackIfEcnrRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

void BtStackIfEcnrRequest::setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const
{
   processConnectionControlTestCommand(testCommand, testData);
}

} //btstackif
