/**
 * @file IBtStackIfWblCallback.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Wbl callback interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface class for wbl callback functionality.
 */

#ifndef _I_BT_STACK_IF_WBL_CALLBACK_H_
#define _I_BT_STACK_IF_WBL_CALLBACK_H_

#include "BtStackIfTypes.h"

namespace btstackif {

/**
 *
 */
class IBtStackIfWblCallback
{
public:
   virtual ~IBtStackIfWblCallback() {}

   /**************************************************************************
    Wbl management related interfaces
    **************************************************************************/
   virtual void fbWblInitializedCB(IN const BTSRequestResult result) = 0;

   virtual void setWblDummyResultCB(IN const BTSRequestResult result) = 0;

   virtual void allowWblCommunicationResultCB(void) = 0;

   virtual void blockWblCommunicationResultCB(void) = 0;

   virtual void wblCommunicationStatusCB(IN const bool enabled) = 0;

   virtual void wblServiceAvailabilityCB(IN const bool serviceAvailable) = 0;

   virtual void wblLastIntendedModeCB(IN const BTSWblLastIntendedModeList& lastIntendedModeList) = 0;

   virtual void wblSupportedRestrictionsCB(IN const BTSWblSupportedRestrictionEntryList& supportedRestrictionList) = 0;

   virtual void wblWiFiSetupStatusCB(IN const BTSWblWiFiSetupStatusEntryList& wifiSetupStatusList) = 0;

   virtual void wblHealthinessIndicatorCB(IN const BTSWblHealthinessIndicator value) = 0;
};

} //btstackif

#endif //_I_BT_STACK_IF_WBL_CALLBACK_H_
