/**
 * @file IBtStackIfMediaPlayerCallback.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief MediaPlayer callback interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface class for mediaplayer callback functionality.
 */

#ifndef _I_BT_STACK_IF_MEDIA_PLAYER_CALLBACK_H_
#define _I_BT_STACK_IF_MEDIA_PLAYER_CALLBACK_H_

#include "BtStackIfTypes.h"

namespace btstackif {

/**
 *
 */
class IBtStackIfMediaPlayerCallback
{
public:
   virtual ~IBtStackIfMediaPlayerCallback() {}

   /**************************************************************************
    MediaPlayer management related interfaces
    **************************************************************************/
   virtual void fbMediaPlayerInitializedCB(IN const BTSRequestResult result) = 0;

   virtual void setMediaPlayerDummyResultCB(IN const BTSRequestResult result) = 0;
};

} //btstackif

#endif //_I_BT_STACK_IF_MEDIA_PLAYER_CALLBACK_H_
