/**
 * @file IBtStackIfConnectionCallback.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Connection callback interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface class for connection callback functionality.
 */

#ifndef _I_BT_STACK_IF_CONNECTION_CALLBACK_H_
#define _I_BT_STACK_IF_CONNECTION_CALLBACK_H_

#include "BtStackIfTypes.h"

namespace btstackif {

/**
 *
 */
class IBtStackIfConnectionCallback
{
public:
   virtual ~IBtStackIfConnectionCallback() {}

   /**************************************************************************
    Connection management related interfaces
    **************************************************************************/
   virtual void fbConnectionInitializedCB(IN const BTSRequestResult result) = 0;

   virtual void localVersionInfoCB(IN const BTSLocalVersionInfo& versionInfo) = 0;

   virtual void switchBluetoothOnOffResultCB(IN const BTSRequestResult result) = 0;

   virtual void currentBluetoothOnOffStatusCB(IN const BTSBluetoothMode bluetoothMode, IN const BTSBluetoothOffReason offReason, IN const BTSAdapterMode adapterMode, IN const BTSBDAddress& localDeviceAddress) = 0;

   virtual void switchBluetoothHardwareOnOffResultCB(IN const BTSRequestResult result) = 0;

   virtual void setLocalBtNameResultCB(IN const BTSRequestResult result) = 0;

   virtual void currentLocalBtNameCB(IN const BTSDeviceName& adapterName) = 0;

   virtual void currentDeviceForRestrictedPairingConnectingCB(IN const BTSBDAddress& expectedDeviceAddress, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void setLocalAdapterModesResultCB(IN const BTSRequestResult result, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void currentDiscoverableModeCB(IN const BTSLocalMode discoverableMode, IN const BTSLocalModeOffReason offReason, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void currentConnectableModeCB(IN const BTSLocalMode connectableMode, IN const BTSLocalModeOffReason offReason, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void startDiscoveryResultCB(IN const BTSRequestResult result, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void stopDiscoveryResultCB(IN const BTSRequestResult result, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void discoveringStatusCB(IN const BTSDiscoveringStatus discoveringStatus, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void discoveredDeviceFoundCB(IN const BTSDiscoveredDeviceInfo& discoveredDevice, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void startPairingResultCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void pinCodeRequestedCB(IN const BTSBDAddress& deviceAddress, IN const BTSDeviceName& deviceName, IN const BTSPairConnectOriginator pairingOriginator, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void secureSimplePairingRequestedCB(IN const BTSBDAddress& deviceAddress, IN const BTSDeviceName& deviceName, IN const BTSSspMode sspMode, IN const BTSNumericValue& numericValue, IN const BTSPairConnectOriginator pairingOriginator, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void pairingFinishedCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSLinkKeyType linkKeyType, IN const BTSLinkKey& linkKey, IN const BTSDLinkKey& dLinkKey, IN const BTSMajorServiceClass& majorServiceClass, IN const BTSMajorDeviceClass majorDeviceClass, IN const BTSMinorDeviceClass minorDeviceClass, IN const BTSDeviceName& deviceName, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void linkKeyRequestedCB(IN const BTSBDAddress& deviceAddress, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void connectProtocolResultCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSProtocolId protocolId, IN const BTSUuid& sppUuid, IN const BTSMasInstanceName& masInstance, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void remoteProtocolConnectRequestCB(IN const BTSBDAddress& deviceAddress, IN const BTSProtocolId protocolId, IN const BTSUuid& sppUuid, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void disconnectProtocolResultCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSProtocolId protocolId, IN const BTSUuid& sppUuid, IN const BTSMasInstanceName& masInstance, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void disconnectDeviceResultCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void protocolConnectionStatusCB(IN const BTSBDAddress& deviceAddress, IN const BTSConnectionStatus connectionStatus, IN const BTSDisconnectReason disconnectReason, IN const BTSProtocolId protocolId, IN const BTSUuid& sppUuid, IN const BTSMasInstanceName& masInstance, IN const BTSDeviceName& rfCommDevice, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void deviceConnectionStatusCB(IN const BTSBDAddress& deviceAddress, IN const BTSConnectionStatus connectionStatus, IN const BTSDisconnectReason disconnectReason, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void deviceCapabilitiesCB(IN const BTSBDAddress& deviceAddress, IN const BTSDeviceCapabilities& deviceCapabilities, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void remoteSupportedServicesCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSSupportedServices& supportedServices, IN const BTSServiceInfoList& serviceInfoList, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void remoteSppCapabilitiesCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSSppCapabilityList& sspCapabilities, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void remoteDeviceIdServiceRecordsCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSDeviceIdServiceRecordList& deviceIdServiceRecords, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void remoteServiceSearchResultCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult supportedServicesResult, IN const BTSRequestResult sppCapabilitiesResult, IN const BTSRequestResult deviceIdServiceRecordsResult, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void remoteNameResultCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSDeviceName& deviceName, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void remoteNameStatusCB(IN const BTSBDAddress& deviceAddress, IN const BTSDeviceName& deviceName, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void linkQualityResultCB(IN const BTSBDAddress& deviceAddress, IN const BTSRequestResult result, IN const BTSRssi rssi, IN const BTSLinkQuality linkQuality, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void startTestModeResultCB(IN const BTSRequestResult result, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void stopTestModeResultCB(IN const BTSRequestResult result, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void testModeStatusCB(IN const BTSBDAddress& deviceAddress, IN const BTSConnectionStatus connectionStatus, IN const BTSSessionHandle sessionHandle = 0) = 0;

   virtual void testModeLinkQualityResultCB(IN const BTSRequestResult result, IN const BTSRssi rssi, IN const BTSLinkQuality linkQuality, IN const BTSSessionHandle sessionHandle = 0) = 0;
};

} //btstackif

#endif //_I_BT_STACK_IF_CONNECTION_CALLBACK_H_
