/**
 * @file BtStackIfMessagingRequest.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Messaging request interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for messaging request functionality.
 */

#ifndef _BT_STACK_IF_MESSAGING_REQUEST_H_
#define _BT_STACK_IF_MESSAGING_REQUEST_H_

#include "BtStackIfBaseRequest.h"
#include "IBtStackIfMessagingRequest.h"

namespace btstackif {

/**
 *
 */
class BtStackIfMessagingRequest : public BtStackIfBaseRequest, public IBtStackIfMessagingRequest
{
public:
   /**
    * Constructor.
    *
    * @param[in] componentFunctionBlock: function block related to general component functionality
    * @param[in] stackInterface: stack interface to be used (Bluetooth stack)
    */
   BtStackIfMessagingRequest(IN const BTSFunctionBlock componentFunctionBlock = BTS_FB_MESSAGING, IN const BTSInterfaceType stackInterface = BTS_IF_ALPS_EVOLUTION_GENIVI);

   /**
    * Destructor.
    */
   virtual ~BtStackIfMessagingRequest();

   virtual void registerCallback(IBtStackIfMessagingCallback* callback);

   virtual BTSSessionHandle getSessionHandle(void) const;

   virtual BTSErrorCode init(IN const BTSLocalMessagingConfiguration& configuration) const;

   virtual BTSErrorCode deInit(void) const;

   virtual void setMessagingDummy(void);

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData) const;

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData) const;

   virtual void setMainControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned int testData) const;

   virtual void setConnectionControlTestCommand(IN const char* testCommand, IN const unsigned char* testData) const;

private:
   /**
    * Default constructor.
    */
   BtStackIfMessagingRequest();
};

} //btstackif

#endif //_BT_STACK_IF_MESSAGING_REQUEST_H_
