/**
 * @file DbusTimeoutControl.cpp
 *
 * @par SW-Component
 * IPC
 *
 * @brief Timeout control for DBUS messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Timeout control for DBUS messages.
 */

#include "DbusTimeoutControl.h"
#include "IDbusResponseTimeoutHandler.h"

namespace btstackif {

DbusTimeoutControl::DbusTimeoutControl()
{
   _handler = NULL;
   _msg = NULL;
   _timer = NULL;
   _inUse = false;
}

DbusTimeoutControl::DbusTimeoutControl(IN IDbusResponseTimeoutHandler* handler)
{
   _handler = handler;
   _msg = NULL;
   _timer = NULL;
   _inUse = false;
}

DbusTimeoutControl::DbusTimeoutControl(IN const DbusTimeoutControl& ref)
{
   _handler = NULL;
   setHandler(ref.getHandler());
   _msg = NULL;
   setMessage(ref.getMessage());
   _timer = NULL;
   setTimer(ref.getTimer());
   _inUse = ref.getInUse();
}

DbusTimeoutControl& DbusTimeoutControl::operator=(IN const DbusTimeoutControl& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   _handler = NULL;
   setHandler(ref.getHandler());
   _msg = NULL;
   setMessage(ref.getMessage());
   _timer = NULL;
   setTimer(ref.getTimer());
   _inUse = ref.getInUse();

   return *this;
}

bool DbusTimeoutControl::operator==(IN const DbusTimeoutControl& ref) const
{
   bool result = true;

   result = (true == result) && (_handler == ref.getHandler());
   result = (true == result) && (_msg == ref.getMessage());
   result = (true == result) && (_timer == ref.getTimer());
   result = (true == result) && (_inUse == ref.getInUse());

   return result;
}

bool DbusTimeoutControl::operator!=(IN const DbusTimeoutControl& ref) const
{
   return !(operator==(ref));
}

DbusTimeoutControl::~DbusTimeoutControl()
{
   _handler = NULL;
   _msg = NULL;
   _timer = NULL;
}

void DbusTimeoutControl::handleTimeout(IN const BTSTimerId timerId)
{
   (void)(timerId);

   if(NULL != _handler)
   {
      _handler->handleDbusResponseTimeout(_msg);
   }
}

} //btstackif
