/**
 * @file IDbusResponseTimeoutHandler.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief Interface for timeout message handler.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for timeout message handler.
 */

#ifndef _I_DBUS_RESPONSE_TIMEOUT_HANDLER_H_
#define _I_DBUS_RESPONSE_TIMEOUT_HANDLER_H_

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;

/**
 *
 */
class IDbusResponseTimeoutHandler
{
public:
   virtual ~IDbusResponseTimeoutHandler() {}

   virtual void handleDbusResponseTimeout(Bts2Ipc_BaseMessage* ptrMessage) = 0;
};

} //btstackif

#endif //_I_DBUS_RESPONSE_TIMEOUT_HANDLER_H_
