/**
 * @file IDbusCallbackHandler.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief Interface for callback DBUS messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for callback DBUS messages.
 */

#ifndef _I_DBUS_CALLBACK_HANDLER_H_
#define _I_DBUS_CALLBACK_HANDLER_H_

namespace btstackif {

/**
 *
 */
class IDbusCallbackHandler
{
public:
   virtual ~IDbusCallbackHandler() {}

   virtual void handleDbusCallbackMessage(void) = 0;
};

} //btstackif

#endif //_I_DBUS_CALLBACK_HANDLER_H_
