/**
 * @file TraceBase.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace base.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of basic trace functionality.
 */

#include <cstdio>
#include <cstring>
#include "FwUtils.h"
#include "FwFormattedDataPrint.h"
#include "TraceBase.h"

namespace btstackif {

ThreadInfo::ThreadInfo()
{
   memset(_buffer, 0, sizeof(_buffer));
   char threadName[THREAD_NAME_BUFFER_SIZE];
   ::fw::FormattedOutputPid processId(::fw::getProcessId());
   ::fw::FormattedOutputPid threadId(::fw::getThreadId());
   snprintf(_buffer, sizeof(_buffer), "[PID=%s TID=%s NAME=%s]", processId.c_str(), threadId.c_str(), ::fw::getThreadName(threadName, sizeof(threadName)));
}

ThreadInfo::ThreadInfo(void* thisPtr)
{
   memset(_buffer, 0, sizeof(_buffer));
   char threadName[THREAD_NAME_BUFFER_SIZE];
   ::fw::FormattedOutputPtr ownPtr((uintptr_t)thisPtr);
   ::fw::FormattedOutputPid processId(::fw::getProcessId());
   ::fw::FormattedOutputPid threadId(::fw::getThreadId());
   snprintf(_buffer, sizeof(_buffer), "[this=%s PID=%s TID=%s NAME=%s]", ownPtr.c_str(), processId.c_str(), threadId.c_str(), ::fw::getThreadName(threadName, sizeof(threadName)));
}

ThreadInfo::~ThreadInfo()
{
}

TimeInfo::TimeInfo()
{
   memset(_buffer, 0, sizeof(_buffer));
   char timeBuffer[LOCAL_TIME_BUFFER_SIZE];
   snprintf(_buffer, sizeof(_buffer), "[TIME=%s]", ::fw::getTime(timeBuffer, sizeof(timeBuffer)));
}

TimeInfo::TimeInfo(void* thisPtr)
{
   memset(_buffer, 0, sizeof(_buffer));
   char timeBuffer[LOCAL_TIME_BUFFER_SIZE];
   ::fw::FormattedOutputPtr ownPtr((uintptr_t)thisPtr);
   snprintf(_buffer, sizeof(_buffer), "[this=%s TIME=%s]", ownPtr.c_str(), ::fw::getTime(timeBuffer, sizeof(timeBuffer)));
}

TimeInfo::~TimeInfo()
{
}

ThreadAndTimeInfo::ThreadAndTimeInfo()
{
   memset(_buffer, 0, sizeof(_buffer));
   char threadName[THREAD_NAME_BUFFER_SIZE];
   char timeBuffer[LOCAL_TIME_BUFFER_SIZE];
   ::fw::FormattedOutputPid processId(::fw::getProcessId());
   ::fw::FormattedOutputPid threadId(::fw::getThreadId());
   snprintf(_buffer, sizeof(_buffer), "[PID=%s TID=%s NAME=%s TIME=%s]", processId.c_str(), threadId.c_str(), ::fw::getThreadName(threadName, sizeof(threadName)), ::fw::getTime(timeBuffer, sizeof(timeBuffer)));
}

ThreadAndTimeInfo::ThreadAndTimeInfo(void* thisPtr)
{
   memset(_buffer, 0, sizeof(_buffer));
   char threadName[THREAD_NAME_BUFFER_SIZE];
   char timeBuffer[LOCAL_TIME_BUFFER_SIZE];
   ::fw::FormattedOutputPtr ownPtr((uintptr_t)thisPtr);
   ::fw::FormattedOutputPid processId(::fw::getProcessId());
   ::fw::FormattedOutputPid threadId(::fw::getThreadId());
   snprintf(_buffer, sizeof(_buffer), "[this=%s PID=%s TID=%s NAME=%s TIME=%s]", ownPtr.c_str(), processId.c_str(), threadId.c_str(), ::fw::getThreadName(threadName, sizeof(threadName)), ::fw::getTime(timeBuffer, sizeof(timeBuffer)));
}

ThreadAndTimeInfo::~ThreadAndTimeInfo()
{
}

} //btstackif
