/**
 * @file ServiceAvailabilityHandler.cpp
 *
 * @par SW-Component
 * Common
 *
 * @brief Service Availability Handler.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of service availability handler.
 */

#include "ServiceAvailabilityHandler.h"
#include "TraceClasses.h"
#include "FwAssert.h"
#include "FwTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BTS_DBUS
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ServiceAvailabilityHandler.cpp.trc.h"
#endif
#endif

namespace btstackif {

ServiceAvailabilityHandler::ServiceAvailabilityHandler()
{
   _serviceAvailable = false;
}

ServiceAvailabilityHandler::~ServiceAvailabilityHandler()
{
}

void ServiceAvailabilityHandler::reset(void)
{
   _semaphore.reset();
}

bool ServiceAvailabilityHandler::waitForServiceAvailable(void)
{
   if(true == _serviceAvailable)
   {
      _semaphore.tryWait();
      return true;
   }
   else
   {
      // wait for service availability
      (void)_semaphore.wait(SERVICE_WAITING_TIMEOUT_MS);
      ETG_TRACE_USR1((" waitForServiceAvailable(): _serviceAvailable=%d [%s]", _serviceAvailable, _serviceName.c_str()));
      return _serviceAvailable;
   }
}

void ServiceAvailabilityHandler::handleServiceAvailability(IN const bool available)
{
   ETG_TRACE_USR1((" handleServiceAvailability(): available=%d [%s]", available, _serviceName.c_str()));
   if(_serviceAvailable != available)
   {
      _serviceAvailable = available;
      if(true == _serviceAvailable)
      {
         _semaphore.post();
      }
   }
}

} //btstackif
