/**
 * @file BtStackInternalOpcodesTrace.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace enum to string.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Trace enum to string.
 * This file is completely generated by parser tooling (code generation). => DO NOT EDIT!
 */

#include "BtStackInternalOpcodesTrace.h"

namespace btstackif {

const char* getApp2BtsOpcode2String(BTSApp2BtsOpcode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case App2BtsOC_None:
         result = "None";
         break;
      case App2BtsOC_Ignore:
         result = "Ignore";
         break;
      case App2BtsOC_ConfigurationBlockStart:
         result = "ConfigurationBlockStart";
         break;
      case App2BtsOC_SetDummy:
         result = "SetDummy";
         break;
      case App2BtsOC_ConfigurationBlockEnd:
         result = "ConfigurationBlockEnd";
         break;
      case App2BtsOC_ConnectionBlockStart:
         result = "ConnectionBlockStart";
         break;
      case App2BtsOC_StartInternalCommunication:
         result = "StartInternalCommunication";
         break;
      case App2BtsOC_TriggerFbConnectionInitialized:
         result = "TriggerFbConnectionInitialized";
         break;
      case App2BtsOC_SwitchBluetoothOnOff:
         result = "SwitchBluetoothOnOff";
         break;
      case App2BtsOC_GetBluetoothOnOffStatus:
         result = "GetBluetoothOnOffStatus";
         break;
      case App2BtsOC_SwitchBluetoothHardwareOnOff:
         result = "SwitchBluetoothHardwareOnOff";
         break;
      case App2BtsOC_SetLocalBtName:
         result = "SetLocalBtName";
         break;
      case App2BtsOC_GetLocalBtName:
         result = "GetLocalBtName";
         break;
      case App2BtsOC_SetDeviceIdServiceRecord:
         result = "SetDeviceIdServiceRecord";
         break;
      case App2BtsOC_SetDeviceForRestrictedPairingConnecting:
         result = "SetDeviceForRestrictedPairingConnecting";
         break;
      case App2BtsOC_SetLocalAdapterModes:
         result = "SetLocalAdapterModes";
         break;
      case App2BtsOC_GetLocalAdapterModes:
         result = "GetLocalAdapterModes";
         break;
      case App2BtsOC_StartDiscovery:
         result = "StartDiscovery";
         break;
      case App2BtsOC_StopDiscovery:
         result = "StopDiscovery";
         break;
      case App2BtsOC_GetDiscoveringStatus:
         result = "GetDiscoveringStatus";
         break;
      case App2BtsOC_StartPairing:
         result = "StartPairing";
         break;
      case App2BtsOC_CancelPairing:
         result = "CancelPairing";
         break;
      case App2BtsOC_SetPinCode:
         result = "SetPinCode";
         break;
      case App2BtsOC_ConfirmSecureSimplePairing:
         result = "ConfirmSecureSimplePairing";
         break;
      case App2BtsOC_SetLinkKey:
         result = "SetLinkKey";
         break;
      case App2BtsOC_ConnectProtocol:
         result = "ConnectProtocol";
         break;
      case App2BtsOC_AcceptRemoteProtocolConnect:
         result = "AcceptRemoteProtocolConnect";
         break;
      case App2BtsOC_RejectRemoteProtocolConnect:
         result = "RejectRemoteProtocolConnect";
         break;
      case App2BtsOC_DisconnectProtocol:
         result = "DisconnectProtocol";
         break;
      case App2BtsOC_DisconnectDevice:
         result = "DisconnectDevice";
         break;
      case App2BtsOC_GetProtocolConnectionStatus:
         result = "GetProtocolConnectionStatus";
         break;
      case App2BtsOC_GetDeviceConnectionStatus:
         result = "GetDeviceConnectionStatus";
         break;
      case App2BtsOC_StartRemoteServiceSearch:
         result = "StartRemoteServiceSearch";
         break;
      case App2BtsOC_CancelRemoteServiceSearch:
         result = "CancelRemoteServiceSearch";
         break;
      case App2BtsOC_QueryRemoteName:
         result = "QueryRemoteName";
         break;
      case App2BtsOC_RequestLinkQuality:
         result = "RequestLinkQuality";
         break;
      case App2BtsOC_StartTestMode:
         result = "StartTestMode";
         break;
      case App2BtsOC_StopTestMode:
         result = "StopTestMode";
         break;
      case App2BtsOC_RequestTestModeLinkQuality:
         result = "RequestTestModeLinkQuality";
         break;
      case App2BtsOC_ConnectionBlockEnd:
         result = "ConnectionBlockEnd";
         break;
      case App2BtsOC_TelephonyBlockStart:
         result = "TelephonyBlockStart";
         break;
      case App2BtsOC_SetTelephonyDummy:
         result = "SetTelephonyDummy";
         break;
      case App2BtsOC_TelephonyBlockEnd:
         result = "TelephonyBlockEnd";
         break;
      case App2BtsOC_PhonebookBlockStart:
         result = "PhonebookBlockStart";
         break;
      case App2BtsOC_SetPhonebookDummy:
         result = "SetPhonebookDummy";
         break;
      case App2BtsOC_PhonebookBlockEnd:
         result = "PhonebookBlockEnd";
         break;
      case App2BtsOC_MessagingBlockStart:
         result = "MessagingBlockStart";
         break;
      case App2BtsOC_SetMessagingDummy:
         result = "SetMessagingDummy";
         break;
      case App2BtsOC_MessagingBlockEnd:
         result = "MessagingBlockEnd";
         break;
      case App2BtsOC_MediaPlayerBlockStart:
         result = "MediaPlayerBlockStart";
         break;
      case App2BtsOC_SetMediaPlayerDummy:
         result = "SetMediaPlayerDummy";
         break;
      case App2BtsOC_MediaPlayerBlockEnd:
         result = "MediaPlayerBlockEnd";
         break;
      case App2BtsOC_WblBlockStart:
         result = "WblBlockStart";
         break;
      case App2BtsOC_SetWblDummy:
         result = "SetWblDummy";
         break;
      case App2BtsOC_TriggerFbWblInitialized:
         result = "TriggerFbWblInitialized";
         break;
      case App2BtsOC_AllowWblCommunication:
         result = "AllowWblCommunication";
         break;
      case App2BtsOC_BlockWblCommunication:
         result = "BlockWblCommunication";
         break;
      case App2BtsOC_GetWblCommunicationStatus:
         result = "GetWblCommunicationStatus";
         break;
      case App2BtsOC_GetWblServiceAvailability:
         result = "GetWblServiceAvailability";
         break;
      case App2BtsOC_GetWblLastIntendedMode:
         result = "GetWblLastIntendedMode";
         break;
      case App2BtsOC_GetWblSupportedRestrictions:
         result = "GetWblSupportedRestrictions";
         break;
      case App2BtsOC_GetWblWiFiSetupStatus:
         result = "GetWblWiFiSetupStatus";
         break;
      case App2BtsOC_GetWblHealthinessIndicator:
         result = "GetWblHealthinessIndicator";
         break;
      case App2BtsOC_WblBlockEnd:
         result = "WblBlockEnd";
         break;
      case App2BtsOC_EcnrBlockStart:
         result = "EcnrBlockStart";
         break;
      case App2BtsOC_SetEcnrDummy:
         result = "SetEcnrDummy";
         break;
      case App2BtsOC_EcnrBlockEnd:
         result = "EcnrBlockEnd";
         break;
      case App2BtsOC_Last:
         result = "Last";
         break;
      default:
         break;
   }

   return result;
}

const char* getBts2AppOpcode2String(BTSBts2AppOpcode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case Bts2AppOC_None:
         result = "None";
         break;
      case Bts2AppOC_ConfigurationBlockStart:
         result = "ConfigurationBlockStart";
         break;
      case Bts2AppOC_SetDummyResult:
         result = "SetDummyResult";
         break;
      case Bts2AppOC_ConfigurationBlockEnd:
         result = "ConfigurationBlockEnd";
         break;
      case Bts2AppOC_ConnectionBlockStart:
         result = "ConnectionBlockStart";
         break;
      case Bts2AppOC_FbConnectionInitialized:
         result = "FbConnectionInitialized";
         break;
      case Bts2AppOC_LocalVersionInfo:
         result = "LocalVersionInfo";
         break;
      case Bts2AppOC_SwitchBluetoothOnOffResult:
         result = "SwitchBluetoothOnOffResult";
         break;
      case Bts2AppOC_CurrentBluetoothOnOffStatus:
         result = "CurrentBluetoothOnOffStatus";
         break;
      case Bts2AppOC_SwitchBluetoothHardwareOnOffResult:
         result = "SwitchBluetoothHardwareOnOffResult";
         break;
      case Bts2AppOC_SetLocalBtNameResult:
         result = "SetLocalBtNameResult";
         break;
      case Bts2AppOC_CurrentLocalBtName:
         result = "CurrentLocalBtName";
         break;
      case Bts2AppOC_CurrentDeviceForRestrictedPairingConnecting:
         result = "CurrentDeviceForRestrictedPairingConnecting";
         break;
      case Bts2AppOC_SetLocalAdapterModesResult:
         result = "SetLocalAdapterModesResult";
         break;
      case Bts2AppOC_CurrentDiscoverableMode:
         result = "CurrentDiscoverableMode";
         break;
      case Bts2AppOC_CurrentConnectableMode:
         result = "CurrentConnectableMode";
         break;
      case Bts2AppOC_StartDiscoveryResult:
         result = "StartDiscoveryResult";
         break;
      case Bts2AppOC_StopDiscoveryResult:
         result = "StopDiscoveryResult";
         break;
      case Bts2AppOC_DiscoveringStatus:
         result = "DiscoveringStatus";
         break;
      case Bts2AppOC_DiscoveredDeviceFound:
         result = "DiscoveredDeviceFound";
         break;
      case Bts2AppOC_StartPairingResult:
         result = "StartPairingResult";
         break;
      case Bts2AppOC_PinCodeRequested:
         result = "PinCodeRequested";
         break;
      case Bts2AppOC_SecureSimplePairingRequested:
         result = "SecureSimplePairingRequested";
         break;
      case Bts2AppOC_PairingFinished:
         result = "PairingFinished";
         break;
      case Bts2AppOC_LinkKeyRequested:
         result = "LinkKeyRequested";
         break;
      case Bts2AppOC_ConnectProtocolResult:
         result = "ConnectProtocolResult";
         break;
      case Bts2AppOC_RemoteProtocolConnectRequest:
         result = "RemoteProtocolConnectRequest";
         break;
      case Bts2AppOC_DisconnectProtocolResult:
         result = "DisconnectProtocolResult";
         break;
      case Bts2AppOC_DisconnectDeviceResult:
         result = "DisconnectDeviceResult";
         break;
      case Bts2AppOC_ProtocolConnectionStatus:
         result = "ProtocolConnectionStatus";
         break;
      case Bts2AppOC_DeviceConnectionStatus:
         result = "DeviceConnectionStatus";
         break;
      case Bts2AppOC_DeviceCapabilities:
         result = "DeviceCapabilities";
         break;
      case Bts2AppOC_RemoteSupportedServices:
         result = "RemoteSupportedServices";
         break;
      case Bts2AppOC_RemoteSppCapabilities:
         result = "RemoteSppCapabilities";
         break;
      case Bts2AppOC_RemoteDeviceIdServiceRecords:
         result = "RemoteDeviceIdServiceRecords";
         break;
      case Bts2AppOC_RemoteServiceSearchResult:
         result = "RemoteServiceSearchResult";
         break;
      case Bts2AppOC_RemoteNameResult:
         result = "RemoteNameResult";
         break;
      case Bts2AppOC_RemoteNameStatus:
         result = "RemoteNameStatus";
         break;
      case Bts2AppOC_LinkQualityResult:
         result = "LinkQualityResult";
         break;
      case Bts2AppOC_StartTestModeResult:
         result = "StartTestModeResult";
         break;
      case Bts2AppOC_StopTestModeResult:
         result = "StopTestModeResult";
         break;
      case Bts2AppOC_TestModeStatus:
         result = "TestModeStatus";
         break;
      case Bts2AppOC_TestModeLinkQualityResult:
         result = "TestModeLinkQualityResult";
         break;
      case Bts2AppOC_ConnectionBlockEnd:
         result = "ConnectionBlockEnd";
         break;
      case Bts2AppOC_TelephonyBlockStart:
         result = "TelephonyBlockStart";
         break;
      case Bts2AppOC_FbTelephonyInitialized:
         result = "FbTelephonyInitialized";
         break;
      case Bts2AppOC_SetTelephonyDummyResult:
         result = "SetTelephonyDummyResult";
         break;
      case Bts2AppOC_TelephonyBlockEnd:
         result = "TelephonyBlockEnd";
         break;
      case Bts2AppOC_PhonebookBlockStart:
         result = "PhonebookBlockStart";
         break;
      case Bts2AppOC_FbPhonebookInitialized:
         result = "FbPhonebookInitialized";
         break;
      case Bts2AppOC_SetPhonebookDummyResult:
         result = "SetPhonebookDummyResult";
         break;
      case Bts2AppOC_PhonebookBlockEnd:
         result = "PhonebookBlockEnd";
         break;
      case Bts2AppOC_MessagingBlockStart:
         result = "MessagingBlockStart";
         break;
      case Bts2AppOC_FbMessagingInitialized:
         result = "FbMessagingInitialized";
         break;
      case Bts2AppOC_SetMessagingDummyResult:
         result = "SetMessagingDummyResult";
         break;
      case Bts2AppOC_MessagingBlockEnd:
         result = "MessagingBlockEnd";
         break;
      case Bts2AppOC_MediaPlayerBlockStart:
         result = "MediaPlayerBlockStart";
         break;
      case Bts2AppOC_FbMediaPlayerInitialized:
         result = "FbMediaPlayerInitialized";
         break;
      case Bts2AppOC_SetMediaPlayerDummyResult:
         result = "SetMediaPlayerDummyResult";
         break;
      case Bts2AppOC_MediaPlayerBlockEnd:
         result = "MediaPlayerBlockEnd";
         break;
      case Bts2AppOC_WblBlockStart:
         result = "WblBlockStart";
         break;
      case Bts2AppOC_FbWblInitialized:
         result = "FbWblInitialized";
         break;
      case Bts2AppOC_SetWblDummyResult:
         result = "SetWblDummyResult";
         break;
      case Bts2AppOC_AllowWblCommunicationResult:
         result = "AllowWblCommunicationResult";
         break;
      case Bts2AppOC_BlockWblCommunicationResult:
         result = "BlockWblCommunicationResult";
         break;
      case Bts2AppOC_WblCommunicationStatus:
         result = "WblCommunicationStatus";
         break;
      case Bts2AppOC_WblServiceAvailability:
         result = "WblServiceAvailability";
         break;
      case Bts2AppOC_WblLastIntendedMode:
         result = "WblLastIntendedMode";
         break;
      case Bts2AppOC_WblSupportedRestrictions:
         result = "WblSupportedRestrictions";
         break;
      case Bts2AppOC_WblWiFiSetupStatus:
         result = "WblWiFiSetupStatus";
         break;
      case Bts2AppOC_WblHealthinessIndicator:
         result = "WblHealthinessIndicator";
         break;
      case Bts2AppOC_WblBlockEnd:
         result = "WblBlockEnd";
         break;
      case Bts2AppOC_EcnrBlockStart:
         result = "EcnrBlockStart";
         break;
      case Bts2AppOC_FbEcnrInitialized:
         result = "FbEcnrInitialized";
         break;
      case Bts2AppOC_SetEcnrDummyResult:
         result = "SetEcnrDummyResult";
         break;
      case Bts2AppOC_EcnrBlockEnd:
         result = "EcnrBlockEnd";
         break;
      case Bts2AppOC_Last:
         result = "Last";
         break;
      default:
         break;
   }

   return result;
}

} //btstackif
