/**
 * @file TraceClasses.h
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace classes.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Trace classes.
 */

#ifndef _TRACE_CLASSES_H_
#define _TRACE_CLASSES_H_

namespace btstackif {

// see \ai_osal_linux\components\bosch_includes\trace\mc_trace.h
// TODO: check how to include file with TR_COMP_XXX definitions
#define TR_COMP_CONNECTIVITY  (256 * 59)
// define offset within connectivity
#define BTS_OFFSET            0x00D0
// define range start
#define BTS_RANGE_START       0x0000
// define range end
#define BTS_RANGE_END         0x001F

#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

enum TrcTraceClassBTS {
   TR_CLASS_BTS_APP2BTS = TR_COMP_CONNECTIVITY + BTS_OFFSET + 0,
   TR_CLASS_BTS_BTS2APP = TR_COMP_CONNECTIVITY + BTS_OFFSET + 1,
   TR_CLASS_BTS_BTS2IPC = TR_COMP_CONNECTIVITY + BTS_OFFSET + 2,
   TR_CLASS_BTS_IPC2BTS = TR_COMP_CONNECTIVITY + BTS_OFFSET + 3,
   TR_CLASS_BTS_COMMON  = TR_COMP_CONNECTIVITY + BTS_OFFSET + 4,
   TR_CLASS_BTS_DBUS    = TR_COMP_CONNECTIVITY + BTS_OFFSET + 5,
   TR_CLASS_BTS_CONTROL = TR_COMP_CONNECTIVITY + BTS_OFFSET + 6,
   TR_CLASS_BTS_SM      = TR_COMP_CONNECTIVITY + BTS_OFFSET + 7
};

#else

#define TR_CLASS_BTS_APP2BTS  "BTS_APP2BTS"
#define TR_CLASS_BTS_BTS2APP  "BTS_BTS2APP"
#define TR_CLASS_BTS_BTS2IPC  "BTS_BTS2IPC"
#define TR_CLASS_BTS_IPC2BTS  "BTS_IPC2BTS"
#define TR_CLASS_BTS_COMMON   "BTS_COMMON_"
#define TR_CLASS_BTS_DBUS     "BTS_DBUS___"
#define TR_CLASS_BTS_CONTROL  "BTS_CONTROL"
#define TR_CLASS_BTS_SM       "BTS_SM_____"

#endif

// BTS ETG replacements
#define BTS_TRACE_USR1(format)         _ETG_TRACE_GEN(__FUNCTION__,__LINE__,5,format)
#define BTS_TRACE_USR2(format)         _ETG_TRACE_GEN(__FUNCTION__,__LINE__,6,format)
#define BTS_TRACE_USR3(format)         _ETG_TRACE_GEN(__FUNCTION__,__LINE__,7,format)
#define BTS_TRACE_USR4(format)         _ETG_TRACE_GEN(__FUNCTION__,__LINE__,8,format)
#define BTS_TRACE_COMP(format)         _ETG_TRACE_GEN(__FUNCTION__,__LINE__,4,format)
#define BTS_TRACE_SYS(format)          _ETG_TRACE_GEN(__FUNCTION__,__LINE__,3,format)
#define BTS_TRACE_SYS_MIN(format)      _ETG_TRACE_GEN(__FUNCTION__,__LINE__,2,format)
#define BTS_TRACE_ERR(format)          _ETG_TRACE_GEN_STDERR(__FUNCTION__,__LINE__,1,format)
#define BTS_TRACE_FATAL(format)        _ETG_TRACE_GEN_STDERR(__FUNCTION__,__LINE__,0,format)
#define BTS_TRACE_ERRMEM(format)       _ETG_TRACE_GEN(__FUNCTION__,__LINE__,0,format)

} //btstackif

#endif //_TRACE_CLASSES_H_
