/**
 * @file TraceBase.h
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace base.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Base class for basic trace functionality.
 */

#ifndef _TRACE_BASE_H_
#define _TRACE_BASE_H_

namespace btstackif {

/**
 * Buffer size definition for common information.
 */
enum
{
   THREAD_NAME_BUFFER_SIZE = 17,
   LOCAL_TIME_BUFFER_SIZE = 16,
   LOCAL_THREAD_INFO_SIZE = 250
};

class ThreadInfo
{
public:
   ThreadInfo();
   ThreadInfo(void* thisPtr);
   virtual ~ThreadInfo();
   inline const char* getInfo(void) const { return _buffer; }

private:
   char _buffer[LOCAL_THREAD_INFO_SIZE];
};

class TimeInfo
{
public:
   TimeInfo();
   TimeInfo(void* thisPtr);
   virtual ~TimeInfo();
   inline const char* getInfo(void) const { return _buffer; }

private:
   char _buffer[LOCAL_THREAD_INFO_SIZE];
};

class ThreadAndTimeInfo
{
public:
   ThreadAndTimeInfo();
   ThreadAndTimeInfo(void* thisPtr);
   virtual ~ThreadAndTimeInfo();
   inline const char* getInfo(void) const { return _buffer; }

private:
   char _buffer[LOCAL_THREAD_INFO_SIZE];
};

} //btstackif

#endif //_TRACE_BASE_H_
