/**
 * @file TTYDeviceMonitor.h
 *
 * @par SW-Component
 * Main
 *
 * @brief TTY device monitor.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for TTY device monitor.
 */

#ifndef _TTY_DEVICE_MONITOR_H_
#define _TTY_DEVICE_MONITOR_H_

#include "FwISingleThreadFunction.h"
#include "BtStackIfTypes.h"
#include "FwLock.h"

// class forward declarations
namespace fw {
class SingleThread;
} //fw

namespace btstackif {

// class forward declarations
class ITTYDeviceMonitorHandler;

/**
 *
 */
class TTYDeviceMonitor : public ::fw::ISingleThreadFunction
{
public:
   /**
    * Default constructor.
    */
   TTYDeviceMonitor();

private:
  /**
    * Copy constructor.
    *
    * DO NOT USE!!!
    *
    * @param[in] ref: reference of object to be copied
    */
   TTYDeviceMonitor(const TTYDeviceMonitor& ref);

   /**
    * Assignment operator.
    *
    * DO NOT USE!!!
    *
    * @param[in] ref: reference of object to be assigned
    */
   TTYDeviceMonitor& operator=(const TTYDeviceMonitor& ref);

public:
   /**
    * Destructor.
    */
   virtual ~TTYDeviceMonitor();

   virtual void threadFunction(void* arguments);

   virtual void setTerminate(void* arguments);

   /**
    * Start TTY device monitor.
    */
   void start(void);

   /**
    * Stop TTY device monitor.
    */
   void stop(void);

   /**
    * Add handler.
    *
    * @param[in] handler: handler
    * @param[in] filter: filter
    */
   void addHandler(IN ITTYDeviceMonitorHandler* handler, IN const ::std::string& filter);

private:
   ::fw::SingleThread* _singleThread;
   bool _terminateWorkerThread;
   bool _workerThreadTerminated;
   const unsigned int _timeoutInMs;
   ::std::map< ITTYDeviceMonitorHandler*, ::std::string > _handlerList; /**< map containing handler and filter */
   LockForeverAndNonReentrant _lock;

   void monitorUdev(void);

   void checkReportedDevice(const char* device, const char* action);
};

} //btstackif

#endif //_TTY_DEVICE_MONITOR_H_
