/**
 * @file ITimeoutHandler.h
 *
 * @par SW-Component
 * Interface
 *
 * @brief Timeout handling interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface class for timeout handling.
 */

#ifndef _I_TIMEOUT_HANDLER_H_
#define _I_TIMEOUT_HANDLER_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

/**
 *
 */
class ITimeoutHandler
{
public:
   virtual ~ITimeoutHandler() {}

   /**
    * Function to handle timeout.
    *
    * @param[in] timerId: timer id
    */
   virtual void handleTimeout(IN const BTSTimerId timerId) = 0;
};

} //btstackif

#endif //_I_TIMEOUT_HANDLER_H_
