/**
 * @file ITTYDeviceMonitorHandler.h
 *
 * @par SW-Component
 * Main
 *
 * @brief TTY device monitor handler interface.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface class for TTY device monitor handler.
 */

#ifndef _I_TTY_DEVICE_MONITOR_HANDLER_H_
#define _I_TTY_DEVICE_MONITOR_HANDLER_H_

#include "BtStackIfTypes.h"

namespace btstackif {

/**
 *
 */
class ITTYDeviceMonitorHandler
{
public:
   virtual ~ITTYDeviceMonitorHandler() {}

   /**
    * Function to handle added/removed character device.
    *
    * @param[in] deviceName: character device name
    * @param[in] added: flag indicating added or removed
    */
   virtual void handleAddedRemovedCharacterDevice(IN const BTSDeviceName& deviceName, IN const bool added) = 0;
};

} //btstackif

#endif //_I_TTY_DEVICE_MONITOR_HANDLER_H_
