/**
 * @file IExtendedTimeoutHandler.h
 *
 * @par SW-Component
 * Timeout interface
 *
 * @brief Timeout handling interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface class for timeout handling.
 */

#ifndef _I_EXTENDED_TIMEOUT_HANDLER_H_
#define _I_EXTENDED_TIMEOUT_HANDLER_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

/**
 *
 */
class IExtendedTimeoutHandler
{
public:
   virtual ~IExtendedTimeoutHandler() {}

   /**
    * Function to handle timeout.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] timerId: timer id
    */
   virtual void handleExtendedTimeout(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSTimerId timerId) = 0;
};

} //btstackif

#endif //_I_EXTENDED_TIMEOUT_HANDLER_H_
