/**
 * @file ExtendedTimerEntry.h
 *
 * @par SW-Component
 * Timer
 *
 * @brief Extended timer entry.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Extended timer entry.
 */

#ifndef _EXTENDED_TIMER_ENTRY_H_
#define _EXTENDED_TIMER_ENTRY_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class IBasicControl;
class IExtendedTimeoutHandler;
class ITimerPool;
class IExtendedTimer;

/**
 *
 */
class ExtendedTimerEntry
{
public:
   ExtendedTimerEntry();

   virtual ~ExtendedTimerEntry();

   ExtendedTimerEntry(const ExtendedTimerEntry& ref);

   ExtendedTimerEntry& operator=(const ExtendedTimerEntry& ref);

   bool operator==(const ExtendedTimerEntry& ref) const;

   bool operator!=(const ExtendedTimerEntry& ref) const;

   inline void setTimerPool(IN ITimerPool* timerPool) { _timerPool = timerPool; }

   void start(IN IBasicControl* control, IN IExtendedTimeoutHandler* handler, IN const BTSTimeValue timeout);

   void stop(void);

   void release(void);

   bool isActive(void) const;

   bool compare(IN const BTSTimerId timerId) const;

   inline IExtendedTimer* getTimer(void) const { return _timer; }

   inline void setTimer(IN IExtendedTimer* ptrTimer) { _timer = ptrTimer; }

   inline bool getInUse(void) const { return _inUse; }

   inline void setInUse(IN const bool enable) { _inUse = enable; }

private:
   ITimerPool* _timerPool; /**< timer pool */
   IExtendedTimer* _timer; /**< timer */
   bool _inUse; /**< in use flag */
};

} //btstackif

#endif //_EXTENDED_TIMER_ENTRY_H_
