/**
 * @file ExtendedTimer.h
 *
 * @par SW-Component
 * Timer
 *
 * @brief Extended timer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Extended timer.
 */

#ifndef _EXTENDED_TIMER_H_
#define _EXTENDED_TIMER_H_

#include "IExtendedTimer.h"
#include "ITimeoutHandler.h"
#include "BtsTimer.h"

namespace btstackif {

/**
 * Extended timer.
 */
class ExtendedTimer : public IExtendedTimer, public ITimeoutHandler
{
public:
   /**
    * Default constructor.
    */
   ExtendedTimer();

   /**
    * Destructor.
    */
   virtual ~ExtendedTimer();

   virtual void start(IN IBasicControl* control, IN IExtendedTimeoutHandler* handler, IN const BTSTimeValue timeout);

   virtual void stop(void);

   virtual bool isActive(void) const;

   virtual BTSTimerId getTimerId(void) const;

   virtual void handleTimeout(IN const BTSTimerId timerId);

private:
   IBasicControl* _controlIf; /**< basic control interface */
   IExtendedTimeoutHandler* _handler; /**< handler for timeout */
   Timer _timer; /**< timer */
};

} //btstackif

#endif //_EXTENDED_TIMER_H_
