/**
 * @file EventQueue.h
 *
 * @par SW-Component
 * Base
 *
 * @brief Event queue.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Base class for event queue handling.
 */

#ifndef _EVENT_QUEUE_H_
#define _EVENT_QUEUE_H_

#include "BtStackInternalTypes.h"
#include "FwLock.h"

#include <semaphore.h>

namespace btstackif {

/**
 *
 */
class EventQueue
{
public:
   EventQueue();
   virtual ~EventQueue();

   void post(IN const BTSEventMask eventMask);
   BTSErrorCode wait(OUT BTSEventMask& eventMask, IN const BTSTimeValue timeoutInMs = 0);
   void clear(void);

private:
   unsigned int _eventMask;
   sem_t _semaphore;
   LockForeverAndNonReentrant _lock;
};

} //btstackif

#endif //_EVENT_QUEUE_H_
