/**
 * @file BtsTimerMaster.h
 *
 * @par SW-Component
 * Timer
 *
 * @brief Timer master.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Timer master handling.
 */

#ifndef _BTS_TIMER_MASTER_H_
#define _BTS_TIMER_MASTER_H_

#include "BtsTimerBase.h"

namespace btstackif {

/**
 *
 */
class TimerMaster : public TimerBase
{
public:
   /**
    * Default constructor.
    */
   TimerMaster();

   /**
    * Destructor.
    */
   virtual ~TimerMaster();

   /**
    * Request current time. Current time will be requested and stored into internal data.
    */
   void requestCurrentTime(void);

   /**
    * Check for elapsed timer.
    */
   void checkElapsedTimer(void);

   /**
    * Set default timer context.
    */
   void setDefaultContext(void);

   /**
    * Create new timer context.
    */
   void createNewContext(void);

   /**
    * Get timer context.
    *
    * @return = timer context
    */
   inline unsigned int getContext(void) const { return _context; }

   /**
    * Set current value for time in seconds. This interface is for debugging/testing only!
    *
    * @param[in] seconds: time in seconds
    */
   void setCurrentTimeSeconds(IN const BTSMonotonicTimeSeconds seconds);
};

} //btstackif

#endif //_BTS_TIMER_MASTER_H_
