/**
 * @file BluetoothResetPin.h
 *
 * @par SW-Component
 * Base
 *
 * @brief Bluetooth Reset Pin.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of Bluetooth reset pin handling.
 */

#ifndef _BLUETOOTH_RESET_PIN_H_
#define _BLUETOOTH_RESET_PIN_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

/**
 *
 */
class BluetoothResetPin
{
public:
   BluetoothResetPin();
   BluetoothResetPin(IN const unsigned int pinId);
   virtual ~BluetoothResetPin();
   void setPinId(IN const unsigned int pinId);
   void performReset(void);

private:
   unsigned int _pinId;
};

} //btstackif

#endif //_BLUETOOTH_RESET_PIN_H_
