/**
 * @file Bts2App_Wbl.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_WBL.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_WBL.
 */

#include "Bts2App_Wbl.h"
#include "BtStackIfCallback.h"
#include "IBtStackIfWblCallback.h"
#include "FwAssert.h"

namespace btstackif {

Bts2App_FbWblInitialized::Bts2App_FbWblInitialized()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_FbWblInitialized)
{
   _result = BTS_REQ_LAST;
}

Bts2App_FbWblInitialized::Bts2App_FbWblInitialized(IN const Bts2App_FbWblInitialized& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_FbWblInitialized& Bts2App_FbWblInitialized::operator=(IN const Bts2App_FbWblInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_FbWblInitialized::~Bts2App_FbWblInitialized()
{
}

void Bts2App_FbWblInitialized::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->fbWblInitializedCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_FbWblInitialized::clone(void) const
{
   return new Bts2App_FbWblInitialized(*this);
}

Bts2App_SetWblDummyResult::Bts2App_SetWblDummyResult()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_SetWblDummyResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SetWblDummyResult::Bts2App_SetWblDummyResult(IN const Bts2App_SetWblDummyResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SetWblDummyResult& Bts2App_SetWblDummyResult::operator=(IN const Bts2App_SetWblDummyResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SetWblDummyResult::~Bts2App_SetWblDummyResult()
{
}

void Bts2App_SetWblDummyResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->setWblDummyResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetWblDummyResult::clone(void) const
{
   return new Bts2App_SetWblDummyResult(*this);
}

Bts2App_AllowWblCommunicationResult::Bts2App_AllowWblCommunicationResult()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_AllowWblCommunicationResult)
{
}

Bts2App_AllowWblCommunicationResult::Bts2App_AllowWblCommunicationResult(IN const Bts2App_AllowWblCommunicationResult& ref)
: Bts2App_BaseMessage(ref)
{
}

Bts2App_AllowWblCommunicationResult& Bts2App_AllowWblCommunicationResult::operator=(IN const Bts2App_AllowWblCommunicationResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   return *this;
}

Bts2App_AllowWblCommunicationResult::~Bts2App_AllowWblCommunicationResult()
{
}

void Bts2App_AllowWblCommunicationResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->allowWblCommunicationResultCB();
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_AllowWblCommunicationResult::clone(void) const
{
   return new Bts2App_AllowWblCommunicationResult(*this);
}

Bts2App_BlockWblCommunicationResult::Bts2App_BlockWblCommunicationResult()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_BlockWblCommunicationResult)
{
}

Bts2App_BlockWblCommunicationResult::Bts2App_BlockWblCommunicationResult(IN const Bts2App_BlockWblCommunicationResult& ref)
: Bts2App_BaseMessage(ref)
{
}

Bts2App_BlockWblCommunicationResult& Bts2App_BlockWblCommunicationResult::operator=(IN const Bts2App_BlockWblCommunicationResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   return *this;
}

Bts2App_BlockWblCommunicationResult::~Bts2App_BlockWblCommunicationResult()
{
}

void Bts2App_BlockWblCommunicationResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->blockWblCommunicationResultCB();
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_BlockWblCommunicationResult::clone(void) const
{
   return new Bts2App_BlockWblCommunicationResult(*this);
}

Bts2App_WblCommunicationStatus::Bts2App_WblCommunicationStatus()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_WblCommunicationStatus)
{
   _enabled = false;
}

Bts2App_WblCommunicationStatus::Bts2App_WblCommunicationStatus(IN const Bts2App_WblCommunicationStatus& ref)
: Bts2App_BaseMessage(ref)
{
   _enabled = ref._enabled;
}

Bts2App_WblCommunicationStatus& Bts2App_WblCommunicationStatus::operator=(IN const Bts2App_WblCommunicationStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _enabled = ref._enabled;

   return *this;
}

Bts2App_WblCommunicationStatus::~Bts2App_WblCommunicationStatus()
{
}

void Bts2App_WblCommunicationStatus::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->wblCommunicationStatusCB(_enabled);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_WblCommunicationStatus::clone(void) const
{
   return new Bts2App_WblCommunicationStatus(*this);
}

Bts2App_WblServiceAvailability::Bts2App_WblServiceAvailability()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_WblServiceAvailability)
{
   _serviceAvailable = false;
}

Bts2App_WblServiceAvailability::Bts2App_WblServiceAvailability(IN const Bts2App_WblServiceAvailability& ref)
: Bts2App_BaseMessage(ref)
{
   _serviceAvailable = ref._serviceAvailable;
}

Bts2App_WblServiceAvailability& Bts2App_WblServiceAvailability::operator=(IN const Bts2App_WblServiceAvailability& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _serviceAvailable = ref._serviceAvailable;

   return *this;
}

Bts2App_WblServiceAvailability::~Bts2App_WblServiceAvailability()
{
}

void Bts2App_WblServiceAvailability::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->wblServiceAvailabilityCB(_serviceAvailable);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_WblServiceAvailability::clone(void) const
{
   return new Bts2App_WblServiceAvailability(*this);
}

Bts2App_WblLastIntendedMode::Bts2App_WblLastIntendedMode()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_WblLastIntendedMode)
{
   // _lastIntendedModeList is empty per default
}

Bts2App_WblLastIntendedMode::Bts2App_WblLastIntendedMode(IN const Bts2App_WblLastIntendedMode& ref)
: Bts2App_BaseMessage(ref)
{
   _lastIntendedModeList = ref._lastIntendedModeList;
}

Bts2App_WblLastIntendedMode& Bts2App_WblLastIntendedMode::operator=(IN const Bts2App_WblLastIntendedMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _lastIntendedModeList = ref._lastIntendedModeList;

   return *this;
}

Bts2App_WblLastIntendedMode::~Bts2App_WblLastIntendedMode()
{
}

void Bts2App_WblLastIntendedMode::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->wblLastIntendedModeCB(_lastIntendedModeList);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_WblLastIntendedMode::clone(void) const
{
   return new Bts2App_WblLastIntendedMode(*this);
}

Bts2App_WblSupportedRestrictions::Bts2App_WblSupportedRestrictions()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_WblSupportedRestrictions)
{
   // _supportedRestrictionList is empty per default
}

Bts2App_WblSupportedRestrictions::Bts2App_WblSupportedRestrictions(IN const Bts2App_WblSupportedRestrictions& ref)
: Bts2App_BaseMessage(ref)
{
   _supportedRestrictionList = ref._supportedRestrictionList;
}

Bts2App_WblSupportedRestrictions& Bts2App_WblSupportedRestrictions::operator=(IN const Bts2App_WblSupportedRestrictions& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _supportedRestrictionList = ref._supportedRestrictionList;

   return *this;
}

Bts2App_WblSupportedRestrictions::~Bts2App_WblSupportedRestrictions()
{
}

void Bts2App_WblSupportedRestrictions::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->wblSupportedRestrictionsCB(_supportedRestrictionList);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_WblSupportedRestrictions::clone(void) const
{
   return new Bts2App_WblSupportedRestrictions(*this);
}

Bts2App_WblWiFiSetupStatus::Bts2App_WblWiFiSetupStatus()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_WblWiFiSetupStatus)
{
   // _wifiSetupStatusList is empty per default
}

Bts2App_WblWiFiSetupStatus::Bts2App_WblWiFiSetupStatus(IN const Bts2App_WblWiFiSetupStatus& ref)
: Bts2App_BaseMessage(ref)
{
   _wifiSetupStatusList = ref._wifiSetupStatusList;
}

Bts2App_WblWiFiSetupStatus& Bts2App_WblWiFiSetupStatus::operator=(IN const Bts2App_WblWiFiSetupStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _wifiSetupStatusList = ref._wifiSetupStatusList;

   return *this;
}

Bts2App_WblWiFiSetupStatus::~Bts2App_WblWiFiSetupStatus()
{
}

void Bts2App_WblWiFiSetupStatus::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->wblWiFiSetupStatusCB(_wifiSetupStatusList);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_WblWiFiSetupStatus::clone(void) const
{
   return new Bts2App_WblWiFiSetupStatus(*this);
}

Bts2App_WblHealthinessIndicator::Bts2App_WblHealthinessIndicator()
: Bts2App_BaseMessage(BTS_FB_WBL, Bts2AppOC_WblHealthinessIndicator)
{
   _value = 0;
}

Bts2App_WblHealthinessIndicator::Bts2App_WblHealthinessIndicator(IN const Bts2App_WblHealthinessIndicator& ref)
: Bts2App_BaseMessage(ref)
{
   _value = ref._value;
}

Bts2App_WblHealthinessIndicator& Bts2App_WblHealthinessIndicator::operator=(IN const Bts2App_WblHealthinessIndicator& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _value = ref._value;

   return *this;
}

Bts2App_WblHealthinessIndicator::~Bts2App_WblHealthinessIndicator()
{
}

void Bts2App_WblHealthinessIndicator::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getWblCallback())
   {
      callback.getWblCallback()->wblHealthinessIndicatorCB(_value);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_WblHealthinessIndicator::clone(void) const
{
   return new Bts2App_WblHealthinessIndicator(*this);
}

} //btstackif
