/**
 * @file Bts2App_Telephony.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_TELEPHONY.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_TELEPHONY.
 */

#include "Bts2App_Telephony.h"
#include "BtStackIfCallback.h"
#include "IBtStackIfTelephonyCallback.h"
#include "FwAssert.h"

namespace btstackif {

Bts2App_FbTelephonyInitialized::Bts2App_FbTelephonyInitialized()
: Bts2App_BaseMessage(BTS_FB_TELEPHONY, Bts2AppOC_FbTelephonyInitialized)
{
   _result = BTS_REQ_LAST;
}

Bts2App_FbTelephonyInitialized::Bts2App_FbTelephonyInitialized(IN const Bts2App_FbTelephonyInitialized& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_FbTelephonyInitialized& Bts2App_FbTelephonyInitialized::operator=(IN const Bts2App_FbTelephonyInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_FbTelephonyInitialized::~Bts2App_FbTelephonyInitialized()
{
}

void Bts2App_FbTelephonyInitialized::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getTelephonyCallback())
   {
      callback.getTelephonyCallback()->fbTelephonyInitializedCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_FbTelephonyInitialized::clone(void) const
{
   return new Bts2App_FbTelephonyInitialized(*this);
}

Bts2App_SetTelephonyDummyResult::Bts2App_SetTelephonyDummyResult()
: Bts2App_BaseMessage(BTS_FB_TELEPHONY, Bts2AppOC_SetTelephonyDummyResult)
{
   _result = BTS_REQ_LAST;
}

Bts2App_SetTelephonyDummyResult::Bts2App_SetTelephonyDummyResult(IN const Bts2App_SetTelephonyDummyResult& ref)
: Bts2App_BaseMessage(ref)
{
   _result = ref._result;
}

Bts2App_SetTelephonyDummyResult& Bts2App_SetTelephonyDummyResult::operator=(IN const Bts2App_SetTelephonyDummyResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2App_BaseMessage::operator=(ref);

   _result = ref._result;

   return *this;
}

Bts2App_SetTelephonyDummyResult::~Bts2App_SetTelephonyDummyResult()
{
}

void Bts2App_SetTelephonyDummyResult::triggerCallback(IN BtStackIfCallback& callback)
{
   if(callback.getTelephonyCallback())
   {
      callback.getTelephonyCallback()->setTelephonyDummyResultCB(_result);
   }
   else
   {
      FW_NORMAL_ASSERT_ALWAYS();
   }
}

Bts2App_BaseMessage* Bts2App_SetTelephonyDummyResult::clone(void) const
{
   return new Bts2App_SetTelephonyDummyResult(*this);
}

} //btstackif
